/*******************************************************************
*  Copyright (c) 2007-2008 Jetico, Inc., Finland
*  All rights reserved.
*
*  File:          optionc.c
*
*  Description:   Parses input options.
*
*  Author:        Alexander Pichuev
*
*  Created:       Sep 10, 2007
*
*  Revision:      $Id: options.c 216 2008-08-28 07:02:34Z pav $
*
*
*******************************************************************/

char wipe_c[]="$Id: options.c 216 2008-08-28 07:02:34Z pav $";

#include "options.h"
#include "schemes.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>

int o_verbose      = FALSE; /* -v,  */
int o_verbose_light= FALSE; /* -l,  */
int o_recurse      = FALSE; /* -r, */
int o_force        = FALSE; /* -f, */
int o_pas_num      = DPASSES;
int o_dont_delete  = FALSE; /* -d, do not delete files after wiping */
int o_wipe_dev     = FALSE; /* -b, wipe devices */
int o_interactive  = TRUE;  /* -i, ask confirmation for wiping, -I disable interactive */
int o_use_DoD      = FALSE; /* -m d and -n switch on using DoD standart */
int o_use_rand     = FALSE; /* -s, use system random instead of SHA-1 */
int o_use_buff     = FALSE; /* -p, use 64Kb random buffer instead of full random */
int o_dont_wipe_fn = FALSE; /* -D, do not wipe file names */
int o_wipe_slacks  = FALSE; /* -S, wipe file slacks */
int o_wipe_free_space = FALSE; /* -F, wipe free space */
int o_nas_wiping   = FALSE; /*-n, NAS wiping */
int o_nas_delay    = 0;     /*-n, NAS wiping delay*/
char *o_user_file  = NULL;  /* -u, user defined patterns (filename) */
int o_use_zero     = FALSE; /* -m z */
int o_use_sector_number  = FALSE; /* -m t */
int o_verify_last_pass = TRUE;

static char *usage_string=""
	"Copyright 1994-2008 Jetico, Inc.  \n"
	"Usage: bcwipe [OPTIONS]... FILE...\n"
	"Remove with wiping FILE(s).\n"
	"\n"
	"  -V       output version information and exit\n"
	"  -md      U.S. DoD seven pass extended character rotation wiping *\n"
	"  -mg      (default) is 35 pass wiping by Peter Gutmann           **\n"
	"  -mt      One pass test mode. First 4 bytes of every 512 bytes block\n"
	"             will contain block number\n"
	"  -mz      One pass zero wiping\n"
	"  -m n     U.S. DoD n pass extended character rotation wiping     *\n"
	"  -w       disable last pass verification for all modes above\n"
	"  -n sec   Wait sec seconds between wiping passes. (NAS mode)     ***\n"
	"  -s       use system random instead of SHA-1\n"
	"  -p       use random pattern instead of full random\n"
	"  -v       explain what is being done\n"
	"  -l       is same as -v but without progress information\n"
	"  -r       process the contents directories recursively\n"
	"  -f       force wiping, never prompt        (use with caution)\n"
	"  -d       do not delete file(s) after wiping\n"
	"  -b       wipe contents of block devices    (use with caution)\n"
	"  -S       wipe file slacks\n"
	"  -F       wipe free space\n"
	"  -i       prompt before any removal (y/[n]/a)\n"
	"             y - yes, n - no(default), a - yes for all\n"
	"  -I       disable interactive prompt\n"
	"  -h       display this help and exit\n"
	"\n"
	"*    - U.S. DoD 5200.28 (Department of Defence)\n"
	"**   - Secure Deletion of Data from Magnetic and Solid-State Memory\n"
	"       http://www.cs.auckland.ac.nz/~pgut001/pubs/secure_del.html\n"  
	"***  - modern enterprise level storage systems (NAS, disk arrays etc.)\n"
	"       employ powerful caches. To avoid undesirable caching effects\n"
	"       use this option to insert delay before file deleting.\n"
	"\n"
	"Report bugs to support@jetico.com \n";
/*
//
//	ShowVersion
//		Reads revision text from wipe_c variable, it is more detailed information about file version.
//
*/
static void ShowVersion()
{
	/*
	//char wipe_c[]="$Id: options.c 216 2008-08-28 07:02:34Z pav $";
	*/

	int len;
	char version[ 20 ];
	int maxLen = sizeof( version );
	strncpy( version, VERSION, maxLen );
	version[ maxLen - 1 ] = '\0';

	len = strlen( wipe_c );

	if ( wipe_c[ len - 1 ] == '$' )
	{
		int i = len;
		while( i-- )
		{
			if ( strncmp( wipe_c + i, "Rev ", 4 ) == 0 )
			{
				int pos = i + 4;
				if ( maxLen > len - pos )
					maxLen = len - pos;

				strncpy( version, wipe_c + i + 4, maxLen );
				version[ maxLen - 1 ] = '\0';
				break;
			}
		}
	}

	printf( "bcwipe version %s\n", version );
}

int parseOptions( int *pArgc, char** pArgv[] )
{
	int c;
	int m_count = 0;

	int argc = *pArgc;
	char **argv = *pArgv;

	while ( (c=getopt(argc,argv,OPTSTRING)) != -1 )
	{
		switch ( (char)c )
		{
			case 'V':
				ShowVersion();
				exit(0);
				return -1;
			case 'l':
				o_verbose_light = TRUE;
				break;
			case 'v':
				o_verbose=TRUE;
				break;
			case 'r':
				o_recurse=TRUE;
				break;
			case 'f':
				o_force=TRUE;
				break;
			case 'D':
				o_dont_wipe_fn=TRUE;
				break;
			case 'd':
				o_dont_delete=TRUE;
				break;
			case 'b':
				o_wipe_dev=TRUE;
				break;
			case 'i':
				o_interactive=TRUE;
				break;
			case 'I':
				o_interactive=FALSE;
				break;
			case 'w':
				o_verify_last_pass = FALSE;
				break;
			case 'm':
				m_count++;
				if (1 == strlen(optarg) && 'd' == optarg[0])
				{
					o_use_DoD=TRUE;
					o_pas_num=QPASSES;
				} else
					if (1 == strlen(optarg) && 'g' == optarg[0])
					{
						o_use_DoD=FALSE;
						o_pas_num=DPASSES;
					} else
						if (1 == strlen(optarg) && 'z' == optarg[0])
						{
							o_use_DoD=FALSE;
							o_pas_num=1;
							o_use_zero=TRUE;
						} else
							if (1 == strlen(optarg) && 't' == optarg[0])
							{
								o_use_DoD=FALSE;
								o_pas_num=1;
								o_use_sector_number=TRUE;
							} else
							{
								o_pas_num=strtol(optarg, NULL, 0);
								o_use_DoD=TRUE;
							}
							break;
			case 'u':
				o_user_file=optarg;
				break;
			case 's':
				o_use_rand=TRUE;
				break;
			case 'S':
				o_wipe_slacks=TRUE;
				break;
			case 'F':
				o_wipe_free_space=TRUE;
				break;
			case 'p':
				o_use_buff=TRUE;
				break;
			case 'n':
				o_nas_wiping=TRUE;
				if (NULL == optarg || !isdigit(optarg[0]))
				{
					fprintf(stderr,"Wrong delay in -n option\n");
					return -1;
				}
				o_nas_delay=strtol(optarg, NULL, 0);
				break;
			case '?':
			case 'h':
			default:
				fprintf(stdout,usage_string);
				exit(0);
				return -1;
		} /* end of switch */
	} /* end of while */

	argc -= optind;
	argv += optind;

	if ( 0 == argc )
	{
		fprintf(stdout,usage_string);
		exit(0);
		return -1;
	}

	if (1 < m_count)
	{
		fprintf(stderr,"Warning: multiple defenition of wipe mode.\n");
		if (o_use_DoD)
		{
			fprintf(stderr,"Using DoD %d passes mode.\n",o_pas_num);
		}else 
			fprintf(stderr,"Using Peter Gutmann mode.\n");

	}

	*pArgc = argc;
	*pArgv = argv;

	return 0;
}
