// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/remoteexecution/v1test/remote_execution.proto

package com.google.devtools.remoteexecution.v1test;

/**
 * <pre>
 * An `Action` captures all the information about an execution which is required
 * to reproduce it.
 * `Action`s are the core component of the [Execution] service. A single
 * `Action` represents a repeatable action that can be performed by the
 * execution service. `Action`s can be succinctly identified by the digest of
 * their wire format encoding and, once an `Action` has been executed, will be
 * cached in the action cache. Future requests can then use the cached result
 * rather than needing to run afresh.
 * When a server completes execution of an
 * [Action][google.devtools.remoteexecution.v1test.Action], it MAY choose to
 * cache the [result][google.devtools.remoteexecution.v1test.ActionResult] in
 * the [ActionCache][google.devtools.remoteexecution.v1test.ActionCache] unless
 * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
 * default, future calls to [Execute][] the same `Action` will also serve their
 * results from the cache. Clients must take care to understand the caching
 * behaviour. Ideally, all `Action`s will be reproducible so that serving a
 * result from cache is always desirable and correct.
 * </pre>
 *
 * Protobuf type {@code google.devtools.remoteexecution.v1test.Action}
 */
public  final class Action extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.devtools.remoteexecution.v1test.Action)
    ActionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Action() {
    outputFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    outputDirectories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Action();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Action(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            com.google.devtools.remoteexecution.v1test.Digest.Builder subBuilder = null;
            if (commandDigest_ != null) {
              subBuilder = commandDigest_.toBuilder();
            }
            commandDigest_ = input.readMessage(com.google.devtools.remoteexecution.v1test.Digest.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(commandDigest_);
              commandDigest_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            com.google.devtools.remoteexecution.v1test.Digest.Builder subBuilder = null;
            if (inputRootDigest_ != null) {
              subBuilder = inputRootDigest_.toBuilder();
            }
            inputRootDigest_ = input.readMessage(com.google.devtools.remoteexecution.v1test.Digest.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(inputRootDigest_);
              inputRootDigest_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              outputFiles_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000001;
            }
            outputFiles_.add(s);
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              outputDirectories_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000002;
            }
            outputDirectories_.add(s);
            break;
          }
          case 42: {
            com.google.devtools.remoteexecution.v1test.Platform.Builder subBuilder = null;
            if (platform_ != null) {
              subBuilder = platform_.toBuilder();
            }
            platform_ = input.readMessage(com.google.devtools.remoteexecution.v1test.Platform.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(platform_);
              platform_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            com.google.protobuf.Duration.Builder subBuilder = null;
            if (timeout_ != null) {
              subBuilder = timeout_.toBuilder();
            }
            timeout_ = input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(timeout_);
              timeout_ = subBuilder.buildPartial();
            }

            break;
          }
          case 56: {

            doNotCache_ = input.readBool();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        outputFiles_ = outputFiles_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        outputDirectories_ = outputDirectories_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.devtools.remoteexecution.v1test.RemoteExecutionProto.internal_static_google_devtools_remoteexecution_v1test_Action_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.remoteexecution.v1test.RemoteExecutionProto.internal_static_google_devtools_remoteexecution_v1test_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.remoteexecution.v1test.Action.class, com.google.devtools.remoteexecution.v1test.Action.Builder.class);
  }

  public static final int COMMAND_DIGEST_FIELD_NUMBER = 1;
  private com.google.devtools.remoteexecution.v1test.Digest commandDigest_;
  /**
   * <pre>
   * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
   * @return Whether the commandDigest field is set.
   */
  public boolean hasCommandDigest() {
    return commandDigest_ != null;
  }
  /**
   * <pre>
   * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
   * @return The commandDigest.
   */
  public com.google.devtools.remoteexecution.v1test.Digest getCommandDigest() {
    return commandDigest_ == null ? com.google.devtools.remoteexecution.v1test.Digest.getDefaultInstance() : commandDigest_;
  }
  /**
   * <pre>
   * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
   */
  public com.google.devtools.remoteexecution.v1test.DigestOrBuilder getCommandDigestOrBuilder() {
    return getCommandDigest();
  }

  public static final int INPUT_ROOT_DIGEST_FIELD_NUMBER = 2;
  private com.google.devtools.remoteexecution.v1test.Digest inputRootDigest_;
  /**
   * <pre>
   * The digest of the root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
   * @return Whether the inputRootDigest field is set.
   */
  public boolean hasInputRootDigest() {
    return inputRootDigest_ != null;
  }
  /**
   * <pre>
   * The digest of the root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
   * @return The inputRootDigest.
   */
  public com.google.devtools.remoteexecution.v1test.Digest getInputRootDigest() {
    return inputRootDigest_ == null ? com.google.devtools.remoteexecution.v1test.Digest.getDefaultInstance() : inputRootDigest_;
  }
  /**
   * <pre>
   * The digest of the root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
   */
  public com.google.devtools.remoteexecution.v1test.DigestOrBuilder getInputRootDigestOrBuilder() {
    return getInputRootDigest();
  }

  public static final int OUTPUT_FILES_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList outputFiles_;
  /**
   * <pre>
   * A list of the output files that the client expects to retrieve from the
   * action. Only the listed files, as well as directories listed in
   * `output_directories`, will be returned to the client as output.
   * Other files that may be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash.
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_files = 3;</code>
   * @return A list containing the outputFiles.
   */
  public com.google.protobuf.ProtocolStringList
      getOutputFilesList() {
    return outputFiles_;
  }
  /**
   * <pre>
   * A list of the output files that the client expects to retrieve from the
   * action. Only the listed files, as well as directories listed in
   * `output_directories`, will be returned to the client as output.
   * Other files that may be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash.
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_files = 3;</code>
   * @return The count of outputFiles.
   */
  public int getOutputFilesCount() {
    return outputFiles_.size();
  }
  /**
   * <pre>
   * A list of the output files that the client expects to retrieve from the
   * action. Only the listed files, as well as directories listed in
   * `output_directories`, will be returned to the client as output.
   * Other files that may be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash.
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_files = 3;</code>
   * @param index The index of the element to return.
   * @return The outputFiles at the given index.
   */
  public java.lang.String getOutputFiles(int index) {
    return outputFiles_.get(index);
  }
  /**
   * <pre>
   * A list of the output files that the client expects to retrieve from the
   * action. Only the listed files, as well as directories listed in
   * `output_directories`, will be returned to the client as output.
   * Other files that may be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash.
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_files = 3;</code>
   * @param index The index of the value to return.
   * @return The bytes of the outputFiles at the given index.
   */
  public com.google.protobuf.ByteString
      getOutputFilesBytes(int index) {
    return outputFiles_.getByteString(index);
  }

  public static final int OUTPUT_DIRECTORIES_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList outputDirectories_;
  /**
   * <pre>
   * A list of the output directories that the client expects to retrieve from
   * the action. Only the contents of the indicated directories (recursively
   * including the contents of their subdirectories) will be
   * returned, as well as files listed in `output_files`. Other files that may
   * be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
   * although not recommended, can be used to capture the entire working
   * directory tree, including inputs).
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_directories = 4;</code>
   * @return A list containing the outputDirectories.
   */
  public com.google.protobuf.ProtocolStringList
      getOutputDirectoriesList() {
    return outputDirectories_;
  }
  /**
   * <pre>
   * A list of the output directories that the client expects to retrieve from
   * the action. Only the contents of the indicated directories (recursively
   * including the contents of their subdirectories) will be
   * returned, as well as files listed in `output_files`. Other files that may
   * be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
   * although not recommended, can be used to capture the entire working
   * directory tree, including inputs).
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_directories = 4;</code>
   * @return The count of outputDirectories.
   */
  public int getOutputDirectoriesCount() {
    return outputDirectories_.size();
  }
  /**
   * <pre>
   * A list of the output directories that the client expects to retrieve from
   * the action. Only the contents of the indicated directories (recursively
   * including the contents of their subdirectories) will be
   * returned, as well as files listed in `output_files`. Other files that may
   * be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
   * although not recommended, can be used to capture the entire working
   * directory tree, including inputs).
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_directories = 4;</code>
   * @param index The index of the element to return.
   * @return The outputDirectories at the given index.
   */
  public java.lang.String getOutputDirectories(int index) {
    return outputDirectories_.get(index);
  }
  /**
   * <pre>
   * A list of the output directories that the client expects to retrieve from
   * the action. Only the contents of the indicated directories (recursively
   * including the contents of their subdirectories) will be
   * returned, as well as files listed in `output_files`. Other files that may
   * be created during command execution are discarded.
   * The paths are specified using forward slashes (`/`) as path separators,
   * even if the execution platform natively uses a different separator. The
   * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
   * although not recommended, can be used to capture the entire working
   * directory tree, including inputs).
   * In order to ensure consistent hashing of the same Action, the output paths
   * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
   * bytes).
   * </pre>
   *
   * <code>repeated string output_directories = 4;</code>
   * @param index The index of the value to return.
   * @return The bytes of the outputDirectories at the given index.
   */
  public com.google.protobuf.ByteString
      getOutputDirectoriesBytes(int index) {
    return outputDirectories_.getByteString(index);
  }

  public static final int PLATFORM_FIELD_NUMBER = 5;
  private com.google.devtools.remoteexecution.v1test.Platform platform_;
  /**
   * <pre>
   * The platform requirements for the execution environment. The server MAY
   * choose to execute the action on any worker satisfying the requirements, so
   * the client SHOULD ensure that running the action on any such worker will
   * have the same result.
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
   * @return Whether the platform field is set.
   */
  public boolean hasPlatform() {
    return platform_ != null;
  }
  /**
   * <pre>
   * The platform requirements for the execution environment. The server MAY
   * choose to execute the action on any worker satisfying the requirements, so
   * the client SHOULD ensure that running the action on any such worker will
   * have the same result.
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
   * @return The platform.
   */
  public com.google.devtools.remoteexecution.v1test.Platform getPlatform() {
    return platform_ == null ? com.google.devtools.remoteexecution.v1test.Platform.getDefaultInstance() : platform_;
  }
  /**
   * <pre>
   * The platform requirements for the execution environment. The server MAY
   * choose to execute the action on any worker satisfying the requirements, so
   * the client SHOULD ensure that running the action on any such worker will
   * have the same result.
   * </pre>
   *
   * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
   */
  public com.google.devtools.remoteexecution.v1test.PlatformOrBuilder getPlatformOrBuilder() {
    return getPlatform();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration timeout_;
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   * The timeout is a part of the
   * [Action][google.devtools.remoteexecution.v1test.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   * @return Whether the timeout field is set.
   */
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   * The timeout is a part of the
   * [Action][google.devtools.remoteexecution.v1test.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   * @return The timeout.
   */
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   * The timeout is a part of the
   * [Action][google.devtools.remoteexecution.v1test.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int DO_NOT_CACHE_FIELD_NUMBER = 7;
  private boolean doNotCache_;
  /**
   * <pre>
   * If true, then the `Action`'s result cannot be cached.
   * </pre>
   *
   * <code>bool do_not_cache = 7;</code>
   * @return The doNotCache.
   */
  public boolean getDoNotCache() {
    return doNotCache_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (commandDigest_ != null) {
      output.writeMessage(1, getCommandDigest());
    }
    if (inputRootDigest_ != null) {
      output.writeMessage(2, getInputRootDigest());
    }
    for (int i = 0; i < outputFiles_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputFiles_.getRaw(i));
    }
    for (int i = 0; i < outputDirectories_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, outputDirectories_.getRaw(i));
    }
    if (platform_ != null) {
      output.writeMessage(5, getPlatform());
    }
    if (timeout_ != null) {
      output.writeMessage(6, getTimeout());
    }
    if (doNotCache_ != false) {
      output.writeBool(7, doNotCache_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (commandDigest_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getCommandDigest());
    }
    if (inputRootDigest_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getInputRootDigest());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < outputFiles_.size(); i++) {
        dataSize += computeStringSizeNoTag(outputFiles_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOutputFilesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < outputDirectories_.size(); i++) {
        dataSize += computeStringSizeNoTag(outputDirectories_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOutputDirectoriesList().size();
    }
    if (platform_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getPlatform());
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getTimeout());
    }
    if (doNotCache_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(7, doNotCache_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.devtools.remoteexecution.v1test.Action)) {
      return super.equals(obj);
    }
    com.google.devtools.remoteexecution.v1test.Action other = (com.google.devtools.remoteexecution.v1test.Action) obj;

    if (hasCommandDigest() != other.hasCommandDigest()) return false;
    if (hasCommandDigest()) {
      if (!getCommandDigest()
          .equals(other.getCommandDigest())) return false;
    }
    if (hasInputRootDigest() != other.hasInputRootDigest()) return false;
    if (hasInputRootDigest()) {
      if (!getInputRootDigest()
          .equals(other.getInputRootDigest())) return false;
    }
    if (!getOutputFilesList()
        .equals(other.getOutputFilesList())) return false;
    if (!getOutputDirectoriesList()
        .equals(other.getOutputDirectoriesList())) return false;
    if (hasPlatform() != other.hasPlatform()) return false;
    if (hasPlatform()) {
      if (!getPlatform()
          .equals(other.getPlatform())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout()
          .equals(other.getTimeout())) return false;
    }
    if (getDoNotCache()
        != other.getDoNotCache()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommandDigest()) {
      hash = (37 * hash) + COMMAND_DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getCommandDigest().hashCode();
    }
    if (hasInputRootDigest()) {
      hash = (37 * hash) + INPUT_ROOT_DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getInputRootDigest().hashCode();
    }
    if (getOutputFilesCount() > 0) {
      hash = (37 * hash) + OUTPUT_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getOutputFilesList().hashCode();
    }
    if (getOutputDirectoriesCount() > 0) {
      hash = (37 * hash) + OUTPUT_DIRECTORIES_FIELD_NUMBER;
      hash = (53 * hash) + getOutputDirectoriesList().hashCode();
    }
    if (hasPlatform()) {
      hash = (37 * hash) + PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getPlatform().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + DO_NOT_CACHE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getDoNotCache());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.devtools.remoteexecution.v1test.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.devtools.remoteexecution.v1test.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An `Action` captures all the information about an execution which is required
   * to reproduce it.
   * `Action`s are the core component of the [Execution] service. A single
   * `Action` represents a repeatable action that can be performed by the
   * execution service. `Action`s can be succinctly identified by the digest of
   * their wire format encoding and, once an `Action` has been executed, will be
   * cached in the action cache. Future requests can then use the cached result
   * rather than needing to run afresh.
   * When a server completes execution of an
   * [Action][google.devtools.remoteexecution.v1test.Action], it MAY choose to
   * cache the [result][google.devtools.remoteexecution.v1test.ActionResult] in
   * the [ActionCache][google.devtools.remoteexecution.v1test.ActionCache] unless
   * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
   * default, future calls to [Execute][] the same `Action` will also serve their
   * results from the cache. Clients must take care to understand the caching
   * behaviour. Ideally, all `Action`s will be reproducible so that serving a
   * result from cache is always desirable and correct.
   * </pre>
   *
   * Protobuf type {@code google.devtools.remoteexecution.v1test.Action}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.devtools.remoteexecution.v1test.Action)
      com.google.devtools.remoteexecution.v1test.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.devtools.remoteexecution.v1test.RemoteExecutionProto.internal_static_google_devtools_remoteexecution_v1test_Action_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.remoteexecution.v1test.RemoteExecutionProto.internal_static_google_devtools_remoteexecution_v1test_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.remoteexecution.v1test.Action.class, com.google.devtools.remoteexecution.v1test.Action.Builder.class);
    }

    // Construct using com.google.devtools.remoteexecution.v1test.Action.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (commandDigestBuilder_ == null) {
        commandDigest_ = null;
      } else {
        commandDigest_ = null;
        commandDigestBuilder_ = null;
      }
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = null;
      } else {
        inputRootDigest_ = null;
        inputRootDigestBuilder_ = null;
      }
      outputFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      outputDirectories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (platformBuilder_ == null) {
        platform_ = null;
      } else {
        platform_ = null;
        platformBuilder_ = null;
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      doNotCache_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.devtools.remoteexecution.v1test.RemoteExecutionProto.internal_static_google_devtools_remoteexecution_v1test_Action_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.remoteexecution.v1test.Action getDefaultInstanceForType() {
      return com.google.devtools.remoteexecution.v1test.Action.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.remoteexecution.v1test.Action build() {
      com.google.devtools.remoteexecution.v1test.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.remoteexecution.v1test.Action buildPartial() {
      com.google.devtools.remoteexecution.v1test.Action result = new com.google.devtools.remoteexecution.v1test.Action(this);
      int from_bitField0_ = bitField0_;
      if (commandDigestBuilder_ == null) {
        result.commandDigest_ = commandDigest_;
      } else {
        result.commandDigest_ = commandDigestBuilder_.build();
      }
      if (inputRootDigestBuilder_ == null) {
        result.inputRootDigest_ = inputRootDigest_;
      } else {
        result.inputRootDigest_ = inputRootDigestBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        outputFiles_ = outputFiles_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.outputFiles_ = outputFiles_;
      if (((bitField0_ & 0x00000002) != 0)) {
        outputDirectories_ = outputDirectories_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.outputDirectories_ = outputDirectories_;
      if (platformBuilder_ == null) {
        result.platform_ = platform_;
      } else {
        result.platform_ = platformBuilder_.build();
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      result.doNotCache_ = doNotCache_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.remoteexecution.v1test.Action) {
        return mergeFrom((com.google.devtools.remoteexecution.v1test.Action)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.remoteexecution.v1test.Action other) {
      if (other == com.google.devtools.remoteexecution.v1test.Action.getDefaultInstance()) return this;
      if (other.hasCommandDigest()) {
        mergeCommandDigest(other.getCommandDigest());
      }
      if (other.hasInputRootDigest()) {
        mergeInputRootDigest(other.getInputRootDigest());
      }
      if (!other.outputFiles_.isEmpty()) {
        if (outputFiles_.isEmpty()) {
          outputFiles_ = other.outputFiles_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureOutputFilesIsMutable();
          outputFiles_.addAll(other.outputFiles_);
        }
        onChanged();
      }
      if (!other.outputDirectories_.isEmpty()) {
        if (outputDirectories_.isEmpty()) {
          outputDirectories_ = other.outputDirectories_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureOutputDirectoriesIsMutable();
          outputDirectories_.addAll(other.outputDirectories_);
        }
        onChanged();
      }
      if (other.hasPlatform()) {
        mergePlatform(other.getPlatform());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getDoNotCache() != false) {
        setDoNotCache(other.getDoNotCache());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.devtools.remoteexecution.v1test.Action parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.devtools.remoteexecution.v1test.Action) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.devtools.remoteexecution.v1test.Digest commandDigest_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.remoteexecution.v1test.Digest, com.google.devtools.remoteexecution.v1test.Digest.Builder, com.google.devtools.remoteexecution.v1test.DigestOrBuilder> commandDigestBuilder_;
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     * @return Whether the commandDigest field is set.
     */
    public boolean hasCommandDigest() {
      return commandDigestBuilder_ != null || commandDigest_ != null;
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     * @return The commandDigest.
     */
    public com.google.devtools.remoteexecution.v1test.Digest getCommandDigest() {
      if (commandDigestBuilder_ == null) {
        return commandDigest_ == null ? com.google.devtools.remoteexecution.v1test.Digest.getDefaultInstance() : commandDigest_;
      } else {
        return commandDigestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    public Builder setCommandDigest(com.google.devtools.remoteexecution.v1test.Digest value) {
      if (commandDigestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commandDigest_ = value;
        onChanged();
      } else {
        commandDigestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    public Builder setCommandDigest(
        com.google.devtools.remoteexecution.v1test.Digest.Builder builderForValue) {
      if (commandDigestBuilder_ == null) {
        commandDigest_ = builderForValue.build();
        onChanged();
      } else {
        commandDigestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    public Builder mergeCommandDigest(com.google.devtools.remoteexecution.v1test.Digest value) {
      if (commandDigestBuilder_ == null) {
        if (commandDigest_ != null) {
          commandDigest_ =
            com.google.devtools.remoteexecution.v1test.Digest.newBuilder(commandDigest_).mergeFrom(value).buildPartial();
        } else {
          commandDigest_ = value;
        }
        onChanged();
      } else {
        commandDigestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    public Builder clearCommandDigest() {
      if (commandDigestBuilder_ == null) {
        commandDigest_ = null;
        onChanged();
      } else {
        commandDigest_ = null;
        commandDigestBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    public com.google.devtools.remoteexecution.v1test.Digest.Builder getCommandDigestBuilder() {
      
      onChanged();
      return getCommandDigestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    public com.google.devtools.remoteexecution.v1test.DigestOrBuilder getCommandDigestOrBuilder() {
      if (commandDigestBuilder_ != null) {
        return commandDigestBuilder_.getMessageOrBuilder();
      } else {
        return commandDigest_ == null ?
            com.google.devtools.remoteexecution.v1test.Digest.getDefaultInstance() : commandDigest_;
      }
    }
    /**
     * <pre>
     * The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest command_digest = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.remoteexecution.v1test.Digest, com.google.devtools.remoteexecution.v1test.Digest.Builder, com.google.devtools.remoteexecution.v1test.DigestOrBuilder> 
        getCommandDigestFieldBuilder() {
      if (commandDigestBuilder_ == null) {
        commandDigestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.remoteexecution.v1test.Digest, com.google.devtools.remoteexecution.v1test.Digest.Builder, com.google.devtools.remoteexecution.v1test.DigestOrBuilder>(
                getCommandDigest(),
                getParentForChildren(),
                isClean());
        commandDigest_ = null;
      }
      return commandDigestBuilder_;
    }

    private com.google.devtools.remoteexecution.v1test.Digest inputRootDigest_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.remoteexecution.v1test.Digest, com.google.devtools.remoteexecution.v1test.Digest.Builder, com.google.devtools.remoteexecution.v1test.DigestOrBuilder> inputRootDigestBuilder_;
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     * @return Whether the inputRootDigest field is set.
     */
    public boolean hasInputRootDigest() {
      return inputRootDigestBuilder_ != null || inputRootDigest_ != null;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     * @return The inputRootDigest.
     */
    public com.google.devtools.remoteexecution.v1test.Digest getInputRootDigest() {
      if (inputRootDigestBuilder_ == null) {
        return inputRootDigest_ == null ? com.google.devtools.remoteexecution.v1test.Digest.getDefaultInstance() : inputRootDigest_;
      } else {
        return inputRootDigestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    public Builder setInputRootDigest(com.google.devtools.remoteexecution.v1test.Digest value) {
      if (inputRootDigestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputRootDigest_ = value;
        onChanged();
      } else {
        inputRootDigestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    public Builder setInputRootDigest(
        com.google.devtools.remoteexecution.v1test.Digest.Builder builderForValue) {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = builderForValue.build();
        onChanged();
      } else {
        inputRootDigestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    public Builder mergeInputRootDigest(com.google.devtools.remoteexecution.v1test.Digest value) {
      if (inputRootDigestBuilder_ == null) {
        if (inputRootDigest_ != null) {
          inputRootDigest_ =
            com.google.devtools.remoteexecution.v1test.Digest.newBuilder(inputRootDigest_).mergeFrom(value).buildPartial();
        } else {
          inputRootDigest_ = value;
        }
        onChanged();
      } else {
        inputRootDigestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    public Builder clearInputRootDigest() {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = null;
        onChanged();
      } else {
        inputRootDigest_ = null;
        inputRootDigestBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    public com.google.devtools.remoteexecution.v1test.Digest.Builder getInputRootDigestBuilder() {
      
      onChanged();
      return getInputRootDigestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    public com.google.devtools.remoteexecution.v1test.DigestOrBuilder getInputRootDigestOrBuilder() {
      if (inputRootDigestBuilder_ != null) {
        return inputRootDigestBuilder_.getMessageOrBuilder();
      } else {
        return inputRootDigest_ == null ?
            com.google.devtools.remoteexecution.v1test.Digest.getDefaultInstance() : inputRootDigest_;
      }
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Digest input_root_digest = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.remoteexecution.v1test.Digest, com.google.devtools.remoteexecution.v1test.Digest.Builder, com.google.devtools.remoteexecution.v1test.DigestOrBuilder> 
        getInputRootDigestFieldBuilder() {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.remoteexecution.v1test.Digest, com.google.devtools.remoteexecution.v1test.Digest.Builder, com.google.devtools.remoteexecution.v1test.DigestOrBuilder>(
                getInputRootDigest(),
                getParentForChildren(),
                isClean());
        inputRootDigest_ = null;
      }
      return inputRootDigestBuilder_;
    }

    private com.google.protobuf.LazyStringList outputFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureOutputFilesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        outputFiles_ = new com.google.protobuf.LazyStringArrayList(outputFiles_);
        bitField0_ |= 0x00000001;
       }
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @return A list containing the outputFiles.
     */
    public com.google.protobuf.ProtocolStringList
        getOutputFilesList() {
      return outputFiles_.getUnmodifiableView();
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @return The count of outputFiles.
     */
    public int getOutputFilesCount() {
      return outputFiles_.size();
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @param index The index of the element to return.
     * @return The outputFiles at the given index.
     */
    public java.lang.String getOutputFiles(int index) {
      return outputFiles_.get(index);
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the outputFiles at the given index.
     */
    public com.google.protobuf.ByteString
        getOutputFilesBytes(int index) {
      return outputFiles_.getByteString(index);
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @param index The index to set the value at.
     * @param value The outputFiles to set.
     * @return This builder for chaining.
     */
    public Builder setOutputFiles(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureOutputFilesIsMutable();
      outputFiles_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @param value The outputFiles to add.
     * @return This builder for chaining.
     */
    public Builder addOutputFiles(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureOutputFilesIsMutable();
      outputFiles_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @param values The outputFiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllOutputFiles(
        java.lang.Iterable<java.lang.String> values) {
      ensureOutputFilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, outputFiles_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearOutputFiles() {
      outputFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output files that the client expects to retrieve from the
     * action. Only the listed files, as well as directories listed in
     * `output_directories`, will be returned to the client as output.
     * Other files that may be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash.
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_files = 3;</code>
     * @param value The bytes of the outputFiles to add.
     * @return This builder for chaining.
     */
    public Builder addOutputFilesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureOutputFilesIsMutable();
      outputFiles_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList outputDirectories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureOutputDirectoriesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        outputDirectories_ = new com.google.protobuf.LazyStringArrayList(outputDirectories_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @return A list containing the outputDirectories.
     */
    public com.google.protobuf.ProtocolStringList
        getOutputDirectoriesList() {
      return outputDirectories_.getUnmodifiableView();
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @return The count of outputDirectories.
     */
    public int getOutputDirectoriesCount() {
      return outputDirectories_.size();
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @param index The index of the element to return.
     * @return The outputDirectories at the given index.
     */
    public java.lang.String getOutputDirectories(int index) {
      return outputDirectories_.get(index);
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the outputDirectories at the given index.
     */
    public com.google.protobuf.ByteString
        getOutputDirectoriesBytes(int index) {
      return outputDirectories_.getByteString(index);
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @param index The index to set the value at.
     * @param value The outputDirectories to set.
     * @return This builder for chaining.
     */
    public Builder setOutputDirectories(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureOutputDirectoriesIsMutable();
      outputDirectories_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @param value The outputDirectories to add.
     * @return This builder for chaining.
     */
    public Builder addOutputDirectories(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureOutputDirectoriesIsMutable();
      outputDirectories_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @param values The outputDirectories to add.
     * @return This builder for chaining.
     */
    public Builder addAllOutputDirectories(
        java.lang.Iterable<java.lang.String> values) {
      ensureOutputDirectoriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, outputDirectories_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearOutputDirectories() {
      outputDirectories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of the output directories that the client expects to retrieve from
     * the action. Only the contents of the indicated directories (recursively
     * including the contents of their subdirectories) will be
     * returned, as well as files listed in `output_files`. Other files that may
     * be created during command execution are discarded.
     * The paths are specified using forward slashes (`/`) as path separators,
     * even if the execution platform natively uses a different separator. The
     * path MUST NOT include a trailing slash, unless the path is `"/"` (which,
     * although not recommended, can be used to capture the entire working
     * directory tree, including inputs).
     * In order to ensure consistent hashing of the same Action, the output paths
     * MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
     * bytes).
     * </pre>
     *
     * <code>repeated string output_directories = 4;</code>
     * @param value The bytes of the outputDirectories to add.
     * @return This builder for chaining.
     */
    public Builder addOutputDirectoriesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureOutputDirectoriesIsMutable();
      outputDirectories_.add(value);
      onChanged();
      return this;
    }

    private com.google.devtools.remoteexecution.v1test.Platform platform_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.remoteexecution.v1test.Platform, com.google.devtools.remoteexecution.v1test.Platform.Builder, com.google.devtools.remoteexecution.v1test.PlatformOrBuilder> platformBuilder_;
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     * @return Whether the platform field is set.
     */
    public boolean hasPlatform() {
      return platformBuilder_ != null || platform_ != null;
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     * @return The platform.
     */
    public com.google.devtools.remoteexecution.v1test.Platform getPlatform() {
      if (platformBuilder_ == null) {
        return platform_ == null ? com.google.devtools.remoteexecution.v1test.Platform.getDefaultInstance() : platform_;
      } else {
        return platformBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    public Builder setPlatform(com.google.devtools.remoteexecution.v1test.Platform value) {
      if (platformBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platform_ = value;
        onChanged();
      } else {
        platformBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    public Builder setPlatform(
        com.google.devtools.remoteexecution.v1test.Platform.Builder builderForValue) {
      if (platformBuilder_ == null) {
        platform_ = builderForValue.build();
        onChanged();
      } else {
        platformBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    public Builder mergePlatform(com.google.devtools.remoteexecution.v1test.Platform value) {
      if (platformBuilder_ == null) {
        if (platform_ != null) {
          platform_ =
            com.google.devtools.remoteexecution.v1test.Platform.newBuilder(platform_).mergeFrom(value).buildPartial();
        } else {
          platform_ = value;
        }
        onChanged();
      } else {
        platformBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    public Builder clearPlatform() {
      if (platformBuilder_ == null) {
        platform_ = null;
        onChanged();
      } else {
        platform_ = null;
        platformBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    public com.google.devtools.remoteexecution.v1test.Platform.Builder getPlatformBuilder() {
      
      onChanged();
      return getPlatformFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    public com.google.devtools.remoteexecution.v1test.PlatformOrBuilder getPlatformOrBuilder() {
      if (platformBuilder_ != null) {
        return platformBuilder_.getMessageOrBuilder();
      } else {
        return platform_ == null ?
            com.google.devtools.remoteexecution.v1test.Platform.getDefaultInstance() : platform_;
      }
    }
    /**
     * <pre>
     * The platform requirements for the execution environment. The server MAY
     * choose to execute the action on any worker satisfying the requirements, so
     * the client SHOULD ensure that running the action on any such worker will
     * have the same result.
     * </pre>
     *
     * <code>.google.devtools.remoteexecution.v1test.Platform platform = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.devtools.remoteexecution.v1test.Platform, com.google.devtools.remoteexecution.v1test.Platform.Builder, com.google.devtools.remoteexecution.v1test.PlatformOrBuilder> 
        getPlatformFieldBuilder() {
      if (platformBuilder_ == null) {
        platformBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.remoteexecution.v1test.Platform, com.google.devtools.remoteexecution.v1test.Platform.Builder, com.google.devtools.remoteexecution.v1test.PlatformOrBuilder>(
                getPlatform(),
                getParentForChildren(),
                isClean());
        platform_ = null;
      }
      return platformBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> timeoutBuilder_;
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
            com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ?
            com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][google.devtools.remoteexecution.v1test.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                getTimeout(),
                getParentForChildren(),
                isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean doNotCache_ ;
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     * @return The doNotCache.
     */
    public boolean getDoNotCache() {
      return doNotCache_;
    }
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     * @param value The doNotCache to set.
     * @return This builder for chaining.
     */
    public Builder setDoNotCache(boolean value) {
      
      doNotCache_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearDoNotCache() {
      
      doNotCache_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.devtools.remoteexecution.v1test.Action)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.remoteexecution.v1test.Action)
  private static final com.google.devtools.remoteexecution.v1test.Action DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.devtools.remoteexecution.v1test.Action();
  }

  public static com.google.devtools.remoteexecution.v1test.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action>
      PARSER = new com.google.protobuf.AbstractParser<Action>() {
    @java.lang.Override
    public Action parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Action(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.remoteexecution.v1test.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

