/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.google.common.collect.ImmutableList;

public enum VariantType {
    DEFAULT(false),
    LIBRARY(true),
    ANDROID_TEST("androidTest", "AndroidTest", true, "_android_test_", 1),
    UNIT_TEST("test", "UnitTest", false, "_unit_test_", 2);

    private final boolean mIsForTesting;
    private final String mPrefix;
    private final String mSuffix;
    private final boolean isSingleBuildType;
    private final String mArtifactName;
    private final int mArtifactType;
    private final boolean exportsDataBindingClassList;

    public static ImmutableList<VariantType> getTestingTypes() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (VariantType variantType : VariantType.values()) {
            if (!variantType.isForTesting()) continue;
            result.add((Object)variantType);
        }
        return result.build();
    }

    private VariantType(boolean exportsDataBindingClassList) {
        this.mIsForTesting = false;
        this.mPrefix = "";
        this.mSuffix = "";
        this.mArtifactName = "_main_";
        this.mArtifactType = 1;
        this.isSingleBuildType = false;
        this.exportsDataBindingClassList = exportsDataBindingClassList;
    }

    private VariantType(String prefix, String suffix, boolean isSingleBuildType, String artifactName, int artifactType) {
        this.mArtifactName = artifactName;
        this.mArtifactType = artifactType;
        this.mIsForTesting = true;
        this.mPrefix = prefix;
        this.mSuffix = suffix;
        this.isSingleBuildType = isSingleBuildType;
        this.exportsDataBindingClassList = false;
    }

    public boolean isForTesting() {
        return this.mIsForTesting;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public String getArtifactName() {
        return this.mArtifactName;
    }

    public int getArtifactType() {
        return this.mArtifactType;
    }

    public boolean isSingleBuildType() {
        return this.isSingleBuildType;
    }

    public boolean isExportDataBindingClassList() {
        return this.exportsDataBindingClassList;
    }
}

