/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class StopWords {
    private final TokenSet set = new TokenSet();

    public StopWords() {
    }

    public StopWords(Data data, String file) throws IOException {
        if (!file.isEmpty()) {
            this.read(IO.get(file), false);
        }
        try (DataOutput out = new DataOutput(data.meta.dbFile("swl"));){
            this.set.write(out);
        }
    }

    public void compile(Data data) {
        if (this.set.isEmpty() && data != null && !data.inMemory()) {
            IOFile file = data.meta.dbFile("swl");
            if (!file.exists()) {
                return;
            }
            try (DataInput in = new DataInput(data.meta.dbFile("swl"));){
                this.set.read(in);
            }
            catch (Exception ex) {
                Util.debug(ex);
            }
        }
    }

    public void read(IO file, boolean exclude) throws IOException {
        for (String term : file.readString().trim().split("\\s+")) {
            byte[] token = Token.token(term);
            if (exclude) {
                this.set.remove(token);
                continue;
            }
            this.set.add(token);
        }
    }

    public boolean contains(byte[] token) {
        return !this.set.isEmpty() && this.set.contains(token);
    }

    public void remove(byte[] token) {
        this.set.remove(token);
    }

    public void add(byte[] token) {
        this.set.add(token);
    }
}

