/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;

public final class FBuilder {
    private static final Atts NO_NAMESPACES = new Atts(0L);
    private static final FNode[] NO_NODES = new FNode[0];
    public FNode root;
    public Atts namespaces;
    public ANodeList attributes;
    public ANodeList children;

    public FBuilder() {
    }

    FBuilder(FNode root) {
        this.root = root;
    }

    public FNode finish() {
        FNode fNode;
        Atts ns = this.namespaces != null ? this.namespaces.optimize() : NO_NAMESPACES;
        ANode[] at = this.attributes != null ? (ANode[])this.attributes.finish() : NO_NODES;
        ANode[] ch = this.children != null ? (ANode[])this.children.finish() : NO_NODES;
        FNode fNode2 = this.root;
        if (fNode2 instanceof FElem) {
            FElem felem = (FElem)fNode2;
            fNode = felem.finish(ns, at, ch);
        } else {
            fNode = ((FDoc)this.root).finish(ch);
        }
        return fNode;
    }

    public FBuilder add(FBuilder builder) {
        return this.add(builder.finish());
    }

    public FBuilder add(ANode node) {
        ANodeList nodes;
        boolean attr = node.type == NodeType.ATTRIBUTE;
        ANodeList aNodeList = nodes = attr ? this.attributes : this.children;
        if (nodes == null) {
            nodes = new ANodeList();
            if (attr) {
                this.attributes = nodes;
            } else {
                this.children = nodes;
            }
        }
        nodes.add(node);
        node.parent(this.root);
        return this;
    }

    public FBuilder add(byte[] value) {
        return value != null && value.length != 0 ? this.add(new FTxt(value)) : this;
    }

    public FBuilder add(Object value) {
        return value != null ? this.add(Token.token(value.toString())) : this;
    }

    public FBuilder add(QNm name, byte[] value) {
        return value != null ? this.add(new FAttr(name, value)) : this;
    }

    public FBuilder add(QNm name, Object value) {
        return value != null ? this.add(name, Token.token(value.toString())) : this;
    }

    public FBuilder addNS(byte[] prefix, byte[] uri) {
        if (this.namespaces == null) {
            this.namespaces = new Atts();
        }
        this.namespaces.add(prefix, uri);
        return this;
    }

    public FBuilder declareNS() {
        QNm name = this.root.qname();
        return this.addNS(name.prefix(), name.uri());
    }

    public boolean isEmpty() {
        return this.attributes == null && this.children == null;
    }
}

