/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import org.basex.query.util.collation.Collation;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

final class HtmlNoCaseCollation
extends Collation {
    static final HtmlNoCaseCollation INSTANCE = new HtmlNoCaseCollation();

    HtmlNoCaseCollation() {
    }

    @Override
    public int compare(byte[] string, byte[] compare) {
        int sl = string.length;
        int cl = compare.length;
        int l = Math.min(sl, cl);
        int s = 0;
        for (int c = 0; s < l || c < l; s += Token.cl(string, s), c += Token.cl(compare, c)) {
            int cp1 = Token.cp(string, s);
            int cp2 = Token.cp(compare, s);
            int d = HtmlNoCaseCollation.compare(HtmlNoCaseCollation.lc(cp1), HtmlNoCaseCollation.lc(cp2));
            if (d == 0) continue;
            return d;
        }
        return Integer.signum(sl - cl);
    }

    @Override
    protected int indexOf(String string, String sub, Collation.Mode mode, InputInfo ii) {
        int tl = string.length();
        int sl = sub.length();
        if (sl == 0) {
            return 0;
        }
        if (tl >= sl) {
            int t;
            int n = t = mode == Collation.Mode.ENDS_WITH ? tl - sl : 0;
            while (t < tl) {
                int s = 0;
                while (t + s < tl && HtmlNoCaseCollation.compare(string.charAt(t + s), sub.charAt(s)) == 0) {
                    if (++s != sl) continue;
                    return mode == Collation.Mode.INDEX_AFTER ? t + s : t;
                }
                if (mode == Collation.Mode.STARTS_WITH) {
                    return -1;
                }
                ++t;
            }
        }
        return -1;
    }

    @Override
    public byte[] key(byte[] string, InputInfo info) {
        ByteList bl = new ByteList(string.length);
        for (byte b : string) {
            bl.add(HtmlNoCaseCollation.lc(b));
        }
        return HtmlNoCaseCollation.key(bl.finish());
    }

    private static int compare(int cp1, int cp2) {
        return Integer.signum(HtmlNoCaseCollation.lc(cp1) - HtmlNoCaseCollation.lc(cp2));
    }

    private static int lc(int cp) {
        return cp >= 65 && cp <= 90 ? cp + 32 : cp;
    }

    public boolean equals(Object obj) {
        return obj instanceof HtmlNoCaseCollation;
    }
}

