/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.name;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public abstract class NameUpdate
extends Update
implements Comparable<NameUpdate> {
    final String name;
    final QueryContext qc;

    NameUpdate(UpdateType type, String name, QueryContext qc, InputInfo info) {
        super(type, info);
        this.name = name;
        this.qc = qc;
    }

    public abstract void prepare() throws QueryException;

    public abstract void apply() throws QueryException;

    protected abstract String operation();

    @Override
    public void merge(Update update) throws QueryException {
        throw QueryError.DB_CONFLICT1_X_X.get(this.info, this.name, this.operation());
    }

    public void databases(StringList db) {
        db.add(this.name);
    }

    public String name() {
        return this.name;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final int compareTo(NameUpdate o) {
        return Integer.signum(this.type.ordinal() - o.type.ordinal());
    }

    final void close() throws QueryException {
        NameUpdate.close(this.name, this.qc, this.info);
    }

    static void close(String name, QueryContext qc, InputInfo info) throws QueryException {
        qc.resources.remove(name);
        if (qc.context.pinned(name)) {
            throw QueryError.DB_LOCK1_X.get(info, name);
        }
    }
}

