/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.UriOptions;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

public class FnParseUri
extends StandardFunc {
    static final String URI = "uri";
    static final String SCHEME = "scheme";
    static final String HIERARCHICAL = "hierarchical";
    static final String AUTHORITY = "authority";
    static final String USERINFO = "userinfo";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String PATH = "path";
    static final String QUERY = "query";
    static final String FRAGMENT = "fragment";
    static final String PATH_SEGMENTS = "path-segments";
    static final String QUERY_PARAMETERS = "query-parameters";
    static final String FILEPATH = "filepath";
    static final String ABSOLUTE = "absolute";
    static final String FILE = "file";
    static final HashSet<String> NON_HIERARCHICAL = new HashSet<String>(Arrays.asList("jar", "mailto", "news", "tag", "tel", "urn"));
    static final Map<String, String> PORTS = Map.of("http", "80", "https", "443", "ftp", "21", "ssh", "22");

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Bln hierarchical;
        boolean absolute;
        String value = this.toStringOrNull(this.arg(0), qc);
        UriOptions options = this.toOptions(this.arg(1), new UriOptions(), qc);
        if (value == null) {
            return Empty.VALUE;
        }
        Object string = value.replace('\\', '/');
        String fragment = "";
        String query = "";
        String scheme = "";
        Object filepath = "";
        String authority = "";
        String userinfo = "";
        String host = "";
        String port = "";
        Regex r = new Regex();
        if (r.has((String)string, "^(.*?)#(.*)$")) {
            string = r.group(1);
            fragment = XMLToken.decodeUri(r.group(2));
        }
        if (r.has((String)string, "^(.*?)\\?(.*)$")) {
            string = r.group(1);
            query = r.group(2);
        }
        if (r.has((String)string, "^([a-zA-Z][-+.A-Za-z0-9]+):(.*)$")) {
            scheme = r.group(1);
            string = r.group(2);
        }
        boolean bl = absolute = !scheme.isEmpty() && fragment.isEmpty();
        if (scheme.isEmpty() || scheme.equalsIgnoreCase(FILE)) {
            if (r.has((String)string, "^/*([a-zA-Z][:|].*)$")) {
                scheme = FILE;
                string = "/" + r.group(1).replaceAll("^(.)\\|", "$1:");
            } else if (options.get(UriOptions.UNC_PATH).booleanValue()) {
                scheme = FILE;
            }
        }
        Item item = NON_HIERARCHICAL.contains(scheme) ? Bln.FALSE : (hierarchical = ((String)string).isEmpty() ? Empty.VALUE : Bln.get(((String)string).startsWith("/")));
        if (hierarchical == Bln.FALSE) {
            absolute = false;
        }
        if (scheme.equalsIgnoreCase(FILE)) {
            if (options.get(UriOptions.UNC_PATH).booleanValue() && r.has((String)string, "^/*(//[^/].*)$")) {
                filepath = string = r.group(1);
            } else if (r.has((String)string, "^/+[A-Za-z]:/.*$")) {
                string = ((String)string).replaceAll("^/+", "/");
                filepath = ((String)string).replaceAll("^/", "");
            } else {
                filepath = string = ((String)string).replaceAll("^/+", "/");
            }
        } else if (hierarchical == Bln.TRUE) {
            if (r.has((String)string, "^//([^/]+)$")) {
                authority = r.group(1);
                string = "";
            } else if (r.has((String)string, "^//([^/]*)(/.*)$")) {
                authority = r.group(1);
                string = r.group(2);
            }
        }
        if (r.has(authority, "^(([^@]*)@)(.*)(:([^:]*))?$")) {
            userinfo = r.group(2);
            if (!options.get(UriOptions.ALLOW_DEPRECATED_FEATURES).booleanValue() && userinfo.contains(":")) {
                userinfo = "";
            }
        }
        if (r.has(authority, "^(([^@]*)@)?(\\[[^\\]]*\\])(:([^:]*))?$")) {
            host = r.group(3);
        } else {
            if (r.has(authority, "^(([^@]*)@)?\\[.*$")) {
                throw QueryError.PARSE_URI_X.get(this.info, value);
            }
            if (r.has(authority, "^(([^@]*)@)?([^:]+)(:([^:]*))?$")) {
                host = r.group(3);
            }
        }
        if (host == null) {
            host = "";
        }
        if (r.has(authority, "^(([^@]*)@)?(\\[[^\\]]*\\])(:([^:]*))?$")) {
            port = r.group(5);
        } else if (r.has(authority, "^(([^@]*)@)?([^:]+)(:([^:]*))?$")) {
            port = r.group(5);
        }
        if (port == null) {
            port = "";
        }
        if (FnParseUri.omitPort(port, scheme, options)) {
            port = "";
        }
        Object path = string;
        if (((String)filepath).isEmpty() && (scheme.isEmpty() || scheme.equalsIgnoreCase(FILE))) {
            filepath = string;
        }
        TokenList segments = new TokenList();
        if (!((String)string).isEmpty()) {
            for (String s : ((String)string).split("/", -1)) {
                segments.add(XMLToken.decodeUri(s));
            }
        }
        XQMap queries = XQMap.empty();
        if (!query.isEmpty()) {
            for (String q : query.split("&")) {
                int eq = q.indexOf(61);
                Str key = eq == -1 ? Str.EMPTY : Str.get(XMLToken.decodeUri(q.substring(0, eq)));
                Str val = Str.get(XMLToken.decodeUri(q.substring(eq + 1)));
                queries = queries.put(key, queries.get(key).append(val, qc));
            }
        }
        filepath = XMLToken.decodeUri((String)filepath);
        MapBuilder mb = new MapBuilder();
        FnParseUri.add(mb, URI, value);
        FnParseUri.add(mb, SCHEME, scheme);
        FnParseUri.add(mb, HIERARCHICAL, hierarchical);
        FnParseUri.add(mb, AUTHORITY, authority);
        FnParseUri.add(mb, USERINFO, userinfo);
        FnParseUri.add(mb, HOST, host);
        FnParseUri.add(mb, PORT, port);
        FnParseUri.add(mb, PATH, path);
        FnParseUri.add(mb, QUERY, query);
        FnParseUri.add(mb, FRAGMENT, fragment);
        FnParseUri.add(mb, PATH_SEGMENTS, StrSeq.get(segments));
        FnParseUri.add(mb, QUERY_PARAMETERS, queries);
        FnParseUri.add(mb, FILEPATH, filepath);
        if (absolute) {
            FnParseUri.add(mb, ABSOLUTE, Bln.TRUE);
        }
        return mb.map();
    }

    static void add(MapBuilder mb, String key, Object value) throws QueryException {
        Value v;
        Value vl;
        Value value2 = value instanceof Value ? (vl = (Value)value) : (v = value.toString().isEmpty() ? Empty.VALUE : Str.get(value.toString()));
        if (!v.isEmpty() && v != XQMap.empty()) {
            mb.put(key, v);
        }
    }

    static boolean omitPort(String port, String scheme, UriOptions options) {
        return options.get(UriOptions.OMIT_DEFAULT_PORTS) != false && Objects.equals(PORTS.get(scheme), port);
    }

    private static final class Regex {
        private Matcher m;

        private Regex() {
        }

        boolean has(String pattern, String input) {
            this.m = Pattern.compile(input).matcher(pattern);
            return this.m.find();
        }

        String group(int i) {
            return this.m.group(i);
        }
    }
}

