/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import java.util.Stack;
import org.basex.data.Data;
import org.basex.index.path.PathIndex;
import org.basex.index.path.PathNode;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.Test;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

final class QuerySuggest
extends QueryParser {
    private final Data data;
    private Stack<ArrayList<PathNode>> stack;
    private ArrayList<PathNode> all;
    private ArrayList<PathNode> current;
    private boolean show;
    private byte[] name;

    QuerySuggest(String query, QueryContext qc, Data data) {
        super(query, null, qc, null);
        this.data = data;
        this.checkInit();
    }

    StringList complete(int index) {
        StringList list = new StringList();
        if (this.show) {
            for (PathNode node : this.current) {
                String nm = Token.string(node.token(this.data));
                if (nm.isEmpty()) continue;
                list.addUnique(nm);
            }
            list.sort();
        }
        return (StringList)((Object)list.add(this.substring(0, index).toString()));
    }

    @Override
    void checkInit() {
        if (this.stack == null || this.stack.empty()) {
            this.stack = new Stack();
            this.all = this.data.paths.root();
            this.current = this.all;
        }
    }

    @Override
    void checkAxis(Axis axis) {
        this.all = axis != Axis.CHILD && axis != Axis.DESCENDANT ? new ArrayList() : PathIndex.desc(this.current, axis == Axis.DESCENDANT);
        this.current = this.all;
        this.show = true;
    }

    @Override
    protected void checkTest(Test test, boolean element) {
        TokenBuilder tb = new TokenBuilder();
        if (!element) {
            tb.add(64);
        }
        if (test != null) {
            tb.add(test.toString(false).replace("*:", ""));
        }
        this.name = tb.finish();
        this.checkTest(this.pos < this.length);
    }

    private void checkTest(boolean eq) {
        if (this.name == null) {
            return;
        }
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        boolean s = false;
        for (PathNode p : this.all) {
            byte[] nm = p.token(this.data);
            if (!Token.startsWith(nm, this.name)) continue;
            if (!eq || Token.eq(nm, this.name)) {
                tmp.add(p);
            }
            s |= !Token.eq(this.name, nm);
        }
        this.show = this.name.length == 0 || s;
        this.current = tmp;
    }

    @Override
    protected void checkPred(boolean open) {
        if (this.stack == null) {
            return;
        }
        if (open) {
            this.checkTest(true);
            this.stack.add(new ArrayList<PathNode>(this.current));
            this.checkAxis(Axis.CHILD);
        } else {
            this.current = this.stack.pop();
            this.show = false;
            this.all = this.current;
        }
    }

    @Override
    public QueryException error(QueryError error, InputInfo info, Object ... arg) {
        return super.error(error, info, arg).suggest(this);
    }
}

