/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.basex.query.QueryContext;
import org.basex.util.Performance;
import org.basex.util.list.LongList;

public final class QueryProfiler {
    public final Map<String, LongList> timing = Collections.synchronizedMap(new LinkedHashMap());
    public final Map<String, LongList> memory = Collections.synchronizedMap(new LinkedHashMap());
    private final QueryContext qc;

    public QueryProfiler(QueryContext qc) {
        this.qc = qc;
    }

    public void evaluate(long result, String label, boolean time, boolean aggregate) {
        if (aggregate) {
            this.add(result, label, time);
        } else {
            this.qc.trace(label, () -> time ? Performance.formatNano(result) : Performance.formatHuman(result));
        }
    }

    public void add(long result, String label, boolean time) {
        String lbl;
        Map<String, LongList> map = time ? this.timing : this.memory;
        LongList values = map.get(lbl = label != null ? label : "");
        if (values == null) {
            if (map.size() >= 1000) {
                return;
            }
            values = new LongList();
            map.put(lbl, values);
        }
        values.add(result);
    }

    public void finish() {
        Consumer<Map> trace = map -> {
            for (Map.Entry entry : map.entrySet()) {
                this.qc.trace((String)entry.getKey(), () -> {
                    LongList values = (LongList)entry.getValue();
                    int runs = values.size();
                    long min = Long.MAX_VALUE;
                    long max = Long.MIN_VALUE;
                    long sum = 0L;
                    for (long l : values.toArray()) {
                        if (l < min) {
                            min = l;
                        }
                        if (l > max) {
                            max = l;
                        }
                        sum += l;
                    }
                    return map == this.timing ? Performance.formatNano(sum) + " (" + runs + " runs, avg: " + Performance.nanoToMilli(sum, runs) + ", min: " + Performance.nanoToMilli(min) + ", max: " + Performance.nanoToMilli(max) + ")" : Performance.formatHuman(sum / (long)runs) + " (avg, " + runs + " runs)";
                });
            }
        };
        trace.accept(this.timing);
        trace.accept(this.memory);
    }
}

