/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.io.serial.AdaptiveSerializer;
import org.basex.io.serial.BaseXSerializer;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.TextSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.ft.FTPos;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTPosNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;

public abstract class Serializer
implements Closeable {
    protected final Stack<QNm> opened = new Stack();
    protected int level;
    protected QNm elem;
    protected QNm closed = QNm.EMPTY;
    protected boolean indent;
    private final Atts nspaces = new Atts(2L).add(Token.XML, QueryText.XML_URI).add(Token.EMPTY, Token.EMPTY);
    private final IntList nstack = new IntList();
    protected StaticContext sc;
    protected boolean more;
    protected int skip;
    protected boolean opening;

    public static Serializer get(OutputStream os) throws IOException {
        return Serializer.get(os, null);
    }

    public static Serializer get(OutputStream os, SerializerOptions sopts) throws IOException {
        SerializerOptions so = sopts == null ? SerializerMode.DEFAULT.get() : sopts;
        return switch (so.get(SerializerOptions.METHOD)) {
            case SerialMethod.XHTML -> new XHTMLSerializer(os, so);
            case SerialMethod.HTML -> new HTMLSerializer(os, so);
            case SerialMethod.TEXT -> new TextSerializer(os, so);
            case SerialMethod.CSV -> CsvSerializer.get(os, so);
            case SerialMethod.JSON -> JsonSerializer.get(os, so);
            case SerialMethod.XML -> new XMLSerializer(os, so);
            case SerialMethod.ADAPTIVE -> new AdaptiveSerializer(os, so);
            default -> new BaseXSerializer(os, so);
        };
    }

    public void serialize(Item item) throws IOException {
        if (item instanceof ANode) {
            ANode node = (ANode)item;
            this.node(node);
        } else if (item instanceof FItem) {
            FItem fitem = (FItem)item;
            this.function(fitem);
        } else {
            this.atomic(item);
        }
        this.more = true;
    }

    @Override
    public void close() throws IOException {
    }

    public boolean finished() {
        return false;
    }

    public void reset() {
    }

    public Serializer sc(StaticContext sctx) {
        this.sc = sctx;
        return this;
    }

    protected void node(ANode node) throws IOException {
        if (node instanceof DBNode) {
            DBNode dbnode = (DBNode)node;
            this.node(dbnode);
        } else {
            this.node((FNode)node);
        }
    }

    protected final void openElement(QNm name) throws IOException {
        this.prepare();
        this.opening = true;
        this.elem = name;
        this.startOpen(name);
        this.closed = QNm.EMPTY;
        this.nstack.push(this.nspaces.size());
    }

    protected final void closeElement() throws IOException {
        this.nspaces.size(this.nstack.pop());
        if (this.opening) {
            this.finishEmpty();
            this.opening = false;
            this.closed = this.elem;
        } else {
            this.elem = this.opened.peek();
            --this.level;
            this.finishClose();
            this.closed = this.opened.pop();
        }
    }

    protected void openDoc(byte[] name) throws IOException {
    }

    protected void closeDoc() throws IOException {
    }

    protected void namespace(byte[] prefix, byte[] uri, boolean standalone) throws IOException {
        byte[] ancUri = this.nsUri(prefix);
        if (ancUri == null || !Token.eq(ancUri, uri)) {
            this.attribute(prefix.length == 0 ? Token.XMLNS : Token.concat(Token.XMLNS_COLON, prefix), uri, standalone);
            this.nspaces.add(prefix, uri);
        }
    }

    protected final byte[] nsUri(byte[] prefix) {
        for (int n = this.nspaces.size() - 1; n >= 0; --n) {
            if (!Token.eq(this.nspaces.name(n), prefix)) continue;
            return this.nspaces.value(n);
        }
        return null;
    }

    protected boolean skipElement(ANode node) {
        return false;
    }

    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
    }

    protected void startOpen(QNm name) throws IOException {
    }

    protected void finishOpen() throws IOException {
    }

    protected void finishEmpty() throws IOException {
    }

    protected void finishClose() throws IOException {
    }

    protected void text(byte[] value, FTPos ftp) throws IOException {
    }

    protected void comment(byte[] value) throws IOException {
    }

    protected void pi(byte[] name, byte[] value) throws IOException {
    }

    protected void atomic(Item item) throws IOException {
    }

    protected void function(FItem item) throws IOException {
    }

    private void node(DBNode node) throws IOException {
        FTPosData fTPosData;
        Data data = node.data();
        int pre = node.pre();
        int kind = data.kind(pre);
        int size = pre + data.size(pre, kind);
        if (kind == 0) {
            this.openDoc(data.text(pre++, true));
            while (pre < size && !this.finished()) {
                this.node((ANode)new DBNode(data, pre));
                pre += data.size(pre, data.kind(pre));
            }
            this.closeDoc();
            return;
        }
        if (node instanceof FTPosNode) {
            FTPosNode ft = (FTPosNode)node;
            fTPosData = ft.ftpos;
        } else {
            fTPosData = null;
        }
        FTPosData ftData = fTPosData;
        boolean nsExist = !data.nspaces.isEmpty();
        TokenSet nsSet = nsExist ? new TokenSet() : null;
        IntList parentStack = new IntList();
        BoolList indentStack = new BoolList();
        while (pre < size && !this.finished()) {
            kind = data.kind(pre);
            int par = data.parent(pre, kind);
            while (!parentStack.isEmpty() && parentStack.peek() >= par) {
                this.closeElement();
                this.indent = indentStack.pop();
                parentStack.pop();
            }
            if (kind == 2) {
                this.prepareText(data.text(pre, true), ftData != null ? ftData.get(data, pre) : null);
                ++pre;
                continue;
            }
            if (kind == 4) {
                this.prepareComment(data.text(pre++, true));
                continue;
            }
            if (kind == 5) {
                this.preparePi(data.name(pre, 5), data.atom(pre++));
                continue;
            }
            if (this.skip > 0 && this.skipElement(new DBNode(data, pre, kind))) {
                pre += data.size(pre, kind);
                continue;
            }
            byte[] name = data.name(pre, kind);
            byte[] nsPrefix = Token.EMPTY;
            byte[] nsUri = null;
            if (nsExist) {
                nsPrefix = Token.prefix(name);
                nsUri = data.nspaces.uri(data.uriId(pre, kind));
            }
            this.openElement(new QNm(name, nsUri));
            if (nsUri == null) {
                nsUri = Token.EMPTY;
            }
            this.namespace(nsPrefix, nsUri, false);
            if (nsExist) {
                nsSet.add(nsUri);
                int p = pre;
                do {
                    Atts ns = data.namespaces(p);
                    int nl = ns.size();
                    for (int n = 0; n < nl; ++n) {
                        nsPrefix = ns.name(n);
                        if (!nsSet.add(nsPrefix)) continue;
                        this.namespace(nsPrefix, ns.value(n), false);
                    }
                } while (this.level == 0 && (p = data.parent(p, data.kind(p))) >= 0 && data.kind(p) == 1);
                nsSet.clear();
            }
            indentStack.push(this.indent);
            int as = pre + data.attSize(pre, kind);
            while (++pre != as) {
                byte[] n = data.name(pre, 3);
                byte[] v = data.text(pre, false);
                this.attribute(n, v, false);
                if (!Token.eq(n, DataText.XML_SPACE) || !this.indent) continue;
                this.indent = !Token.eq(v, DataText.PRESERVE);
            }
            parentStack.push(par);
        }
        while (!parentStack.isEmpty()) {
            this.closeElement();
            this.indent = indentStack.pop();
            parentStack.pop();
        }
    }

    private void node(FNode node) throws IOException {
        Type type = node.type;
        if (type == NodeType.COMMENT) {
            this.prepareComment(node.string());
        } else if (type == NodeType.TEXT) {
            this.prepareText(node.string(), null);
        } else if (type == NodeType.PROCESSING_INSTRUCTION) {
            this.preparePi(node.name(), node.string());
        } else if (type == NodeType.ATTRIBUTE) {
            this.attribute(node.name(), node.string(), true);
        } else if (type == NodeType.NAMESPACE_NODE) {
            this.namespace(node.name(), node.string(), true);
        } else if (type == NodeType.DOCUMENT_NODE) {
            this.openDoc(node.baseURI());
            for (ANode nd : node.childIter()) {
                this.node(nd);
            }
            this.closeDoc();
        } else if (this.skip == 0 || !this.skipElement(node)) {
            ANode n;
            ANode nd;
            QNm name = node.qname();
            this.openElement(name);
            Atts nsp = node.namespaces();
            int ps = nsp.size();
            for (int p = 0; p < ps; ++p) {
                this.namespace(nsp.name(p), nsp.value(p), false);
            }
            this.namespace(name.prefix(), name.uri(), false);
            boolean i = this.indent;
            BasicNodeIter iter = node.attributeIter();
            while ((nd = iter.next()) != null) {
                byte[] n2 = nd.name();
                byte[] v = nd.string();
                this.attribute(n2, v, false);
                if (!Token.eq(n2, DataText.XML_SPACE) || !this.indent) continue;
                this.indent = !Token.eq(v, DataText.PRESERVE);
            }
            iter = node.childIter();
            while ((n = iter.next()) != null) {
                this.node(n);
            }
            this.closeElement();
            this.indent = i;
        }
    }

    private void prepareComment(byte[] value) throws IOException {
        this.prepare();
        this.comment(value);
    }

    private void prepareText(byte[] value, FTPos ftp) throws IOException {
        this.prepare();
        this.text(value, ftp);
    }

    private void preparePi(byte[] name, byte[] value) throws IOException {
        this.prepare();
        this.pi(name, value);
    }

    private void prepare() throws IOException {
        if (!this.opening) {
            return;
        }
        this.opening = false;
        this.finishOpen();
        this.opened.push(this.elem);
        ++this.level;
    }

    public static byte[] value(byte[] value, char quote, boolean chop) {
        boolean quoting = quote != '\u0000';
        TokenBuilder tb = new TokenBuilder();
        if (quoting) {
            tb.add(quote);
        }
        int c = 0;
        TokenParser tp = new TokenParser(value);
        while (tp.more()) {
            if (chop && c == 200) {
                tb.add("...");
                break;
            }
            int cp = tp.next();
            if (cp == 38) {
                tb.add(DataText.E_AMP);
            } else if (cp == 13) {
                tb.add(DataText.E_CR);
            } else if (cp == 10) {
                tb.add(DataText.E_NL);
            } else if (cp == quote) {
                tb.add(quote).add(quote);
            } else {
                tb.add(cp);
            }
            ++c;
        }
        if (quoting) {
            tb.add(quote);
        }
        return tb.finish();
    }
}

