/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.io.random.TableAccess;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.Util;

public final class TableDiskAccess
extends TableAccess {
    private final Buffers buffers = new Buffers();
    private final RandomAccessFile file;
    private BitArray usedPages;
    private FileLock lock;
    private int[] fPreIndex;
    private int[] pageIndex;
    private int pages;
    private int used;
    private int page = -1;
    private int firstPre = -1;
    private int nextPre = -1;

    public TableDiskAccess(MetaData meta, boolean write) throws IOException {
        super(meta);
        try (DataInput in = new DataInput(meta.dbFile("tbli"));){
            this.pages = in.readNum();
            this.used = in.readNum();
            if (this.used == Integer.MAX_VALUE) {
                this.used = this.pages;
            } else if (this.used != 0) {
                this.fPreIndex = in.readNums();
                this.pageIndex = in.readNums();
                int s = in.readNum();
                this.usedPages = new BitArray(in.readLongs(s), this.used);
            }
        }
        this.file = new RandomAccessFile(meta.dbFile("tbl").file(), "rw");
        if (!this.lock(write)) {
            throw new BaseXException(Text.DB_PINNED_X, meta.name);
        }
    }

    public static boolean locked(String db, Context ctx) {
        boolean bl;
        block9: {
            IOFile table = MetaData.file(ctx.soptions.dbPath(db), "tbl");
            if (!table.exists()) {
                return false;
            }
            FileChannel fc = new RandomAccessFile(table.file(), "rw").getChannel();
            try {
                boolean bl2 = bl = fc.tryLock() == null;
                if (fc == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    return true;
                }
            }
            fc.close();
        }
        return bl;
    }

    @Override
    public synchronized void flush(boolean all) throws IOException {
        for (Buffer buffer : this.buffers.all()) {
            this.write(buffer);
        }
        if (!this.dirty || !all) {
            return;
        }
        try (DataOutput out = new DataOutput(this.meta.dbFile("tbli"));){
            int p = this.pages;
            boolean regular = true;
            if (this.fPreIndex != null) {
                int i;
                regular = p == this.used;
                for (i = 0; i < p && regular; ++i) {
                    regular = this.fPreIndex[i] == i * 256;
                }
                for (i = 0; i < p && regular; ++i) {
                    regular = this.pageIndex[i] == i;
                }
                if (regular) {
                    this.removeMapping();
                }
            }
            if (regular) {
                out.writeNum(p);
                out.writeNum(this.used == 0 ? 0 : Integer.MAX_VALUE);
            } else {
                int s;
                out.writeNum(p);
                out.writeNum(this.used);
                out.writeNum(p);
                for (s = 0; s < p; ++s) {
                    out.writeNum(this.fPreIndex[s]);
                }
                out.writeNum(p);
                for (s = 0; s < p; ++s) {
                    out.writeNum(this.pageIndex[s]);
                }
                out.writeLongs(this.usedPages.toArray());
            }
        }
        this.dirty = false;
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush(true);
        this.file.close();
    }

    @Override
    public boolean lock(boolean write) {
        try {
            if (this.lock != null) {
                if (write != this.lock.isShared()) {
                    return true;
                }
                this.lock.release();
            }
            this.lock = this.file.getChannel().tryLock(0L, Long.MAX_VALUE, !write);
            return this.lock != null;
        }
        catch (IOException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public synchronized int read1(int pre, int offset) {
        int o = offset + this.cursor(pre);
        byte[] data = this.buffers.current().data;
        return data[o] & 0xFF;
    }

    @Override
    public synchronized int read2(int pre, int offset) {
        int o = offset + this.cursor(pre);
        byte[] data = this.buffers.current().data;
        return ((data[o] & 0xFF) << 8) + (data[o + 1] & 0xFF);
    }

    @Override
    public synchronized int read4(int pre, int offset) {
        int o = offset + this.cursor(pre);
        byte[] data = this.buffers.current().data;
        return ((data[o] & 0xFF) << 24) + ((data[o + 1] & 0xFF) << 16) + ((data[o + 2] & 0xFF) << 8) + (data[o + 3] & 0xFF);
    }

    @Override
    public synchronized long read5(int pre, int offset) {
        int o = offset + this.cursor(pre);
        byte[] data = this.buffers.current().data;
        return ((long)(data[o] & 0xFF) << 32) + ((long)(data[o + 1] & 0xFF) << 24) + (long)((data[o + 2] & 0xFF) << 16) + (long)((data[o + 3] & 0xFF) << 8) + (long)(data[o + 4] & 0xFF);
    }

    @Override
    public void write1(int pre, int offset, int value) {
        int o = offset + this.cursor(pre);
        Buffer buffer = this.buffers.current();
        buffer.data[o] = (byte)value;
        buffer.dirty = true;
    }

    @Override
    public void write2(int pre, int offset, int value) {
        int o = offset + this.cursor(pre);
        Buffer buffer = this.buffers.current();
        byte[] data = buffer.data;
        data[o] = (byte)(value >>> 8);
        data[o + 1] = (byte)value;
        buffer.dirty = true;
    }

    @Override
    public void write4(int pre, int offset, int value) {
        int o = offset + this.cursor(pre);
        Buffer buffer = this.buffers.current();
        byte[] data = buffer.data;
        data[o] = (byte)(value >>> 24);
        data[o + 1] = (byte)(value >>> 16);
        data[o + 2] = (byte)(value >>> 8);
        data[o + 3] = (byte)value;
        buffer.dirty = true;
    }

    @Override
    public void write5(int pre, int offset, long value) {
        int o = offset + this.cursor(pre);
        Buffer buffer = this.buffers.current();
        byte[] data = buffer.data;
        data[o] = (byte)(value >>> 32);
        data[o + 1] = (byte)(value >>> 24);
        data[o + 2] = (byte)(value >>> 16);
        data[o + 3] = (byte)(value >>> 8);
        data[o + 4] = (byte)value;
        buffer.dirty = true;
    }

    @Override
    protected void copy(byte[] entries, int first, int last) {
        this.dirty();
        int o = 0;
        int i = first;
        while (i < last) {
            int off = this.cursor(i);
            Buffer buffer = this.buffers.current();
            Array.copy(entries, o, 16, buffer.data, off);
            buffer.dirty = true;
            ++i;
            o += 16;
        }
    }

    @Override
    public void delete(int pre, int count) {
        if (count == 0) {
            return;
        }
        this.dirty();
        this.cursor(pre);
        int from = pre - this.firstPre;
        int last = pre + count;
        if (last <= this.nextPre) {
            if (last < this.nextPre) {
                TableDiskAccess.delete(this.buffers.current(), from, from + count, this.nextPre - last);
            }
            this.decreasePre(count);
            if (this.firstPre == this.nextPre) {
                this.usedPages.clear(this.pageIndex[this.page]);
                this.deletePages(1);
                this.readPage(this.page);
            }
        } else {
            int unused = 0;
            while (last > this.nextPre) {
                if (from == 0) {
                    ++unused;
                    this.usedPages.clear(this.pageIndex[this.page]);
                }
                this.setPage(this.page + 1);
                from = 0;
            }
            this.read(this.pageIndex[this.page]);
            Buffer buffer = this.buffers.current();
            if (last == this.nextPre) {
                this.usedPages.clear((int)buffer.pos);
                ++unused;
                if (this.page + 1 < this.used) {
                    this.readPage(this.page + 1);
                } else {
                    ++this.page;
                }
            } else {
                TableDiskAccess.delete(buffer, 0, last - this.firstPre, this.nextPre - last);
            }
            if (unused > 0) {
                this.page -= unused;
                this.deletePages(unused);
            }
            this.fPreIndex[this.page] = pre;
            this.firstPre = pre;
            this.decreasePre(count);
        }
        if (this.used == 0) {
            this.buffers.init();
            this.removeMapping();
            this.pages = 1;
        }
    }

    @Override
    public void insert(int pre, byte[] entries) {
        int exp;
        int nnew = entries.length;
        if (nnew == 0) {
            return;
        }
        this.dirty();
        int nr = nnew >>> 4;
        int split = 0;
        if (this.used == 0) {
            this.readPage(0);
            this.usedPages.set(0);
            ++this.used;
        } else if (pre > 0) {
            split = this.cursor(pre - 1) + 16;
        }
        int nold = this.nextPre - this.firstPre << 4;
        int moved = nold - split;
        Buffer buffer = this.buffers.current();
        if (nold + nnew <= 4096) {
            Array.insert(buffer.data, split, nnew, nold, entries);
            buffer.dirty = true;
            int i = this.page + 1;
            while (i < this.used) {
                int n = i++;
                this.fPreIndex[n] = this.fPreIndex[n] + nr;
            }
            this.nextPre += nr;
            this.meta.size += nr;
            return;
        }
        byte[] all = new byte[nnew + moved];
        Array.copy(entries, nnew, all);
        Array.copy(buffer.data, split, moved, all, nnew);
        int nrem = 4096 - split;
        if (nrem > 0) {
            Array.copyFromStart(all, nrem, buffer.data, split);
            buffer.dirty = true;
        }
        int req = all.length - nrem;
        int needed = req >>> 12;
        int remain = req & 0xFFF;
        if (remain > 0) {
            if (this.page + 1 < this.used) {
                int o = this.occSpace(this.page + 1) << 4;
                if (remain <= 4096 - o) {
                    this.readPage(this.page + 1);
                    buffer = this.buffers.current();
                    Array.copyFromStart(buffer.data, o, buffer.data, remain);
                    Array.copyToStart(all, all.length - remain, remain, buffer.data);
                    buffer.dirty = true;
                    int n = this.page;
                    this.fPreIndex[n] = this.fPreIndex[n] - (remain >>> 4);
                    this.readPage(this.page - 1);
                } else {
                    ++needed;
                }
            } else {
                ++needed;
            }
        }
        if ((exp = this.pages + needed - (this.pages - this.used)) > this.fPreIndex.length) {
            int ns = Math.max(this.fPreIndex.length << 1, exp);
            this.fPreIndex = Arrays.copyOf(this.fPreIndex, ns);
            this.pageIndex = Arrays.copyOf(this.pageIndex, ns);
        }
        Array.insert(this.fPreIndex, this.page + 1, needed, this.used, null);
        Array.insert(this.pageIndex, this.page + 1, needed, this.used, null);
        while (needed-- > 0) {
            int p = this.usedPages.nextFree();
            this.usedPages.set(p);
            this.read(p);
            ++this.used;
            ++this.page;
            nrem += this.write(all, nrem);
            this.fPreIndex[this.page] = this.fPreIndex[this.page - 1] + 256;
            this.pageIndex[this.page] = (int)this.buffers.current().pos;
        }
        int i = this.page + 1;
        while (i < this.used) {
            int n = i++;
            this.fPreIndex[n] = this.fPreIndex[n] + nr;
        }
        this.meta.size += nr;
        this.firstPre = this.fPreIndex[this.page];
        this.nextPre = this.page + 1 < this.used && this.fPreIndex[this.page + 1] < this.meta.size ? this.fPreIndex[this.page + 1] : this.meta.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.className(this)).append(" (").append("pages: ").append(this.pages);
        sb.append(", used: ").append(this.used).append(", page: ").append(this.page);
        sb.append(", firstPre: ").append(this.firstPre).append(", nextPre: ").append(this.nextPre).append(")");
        if (this.fPreIndex != null) {
            sb.append("\n- FPres: ").append(Arrays.toString(this.fPreIndex));
        }
        if (this.pageIndex != null) {
            sb.append("\n- Pages: ").append(Arrays.toString(this.pageIndex));
        }
        if (this.usedPages != null) {
            sb.append("\n- Used Pages: ").append(this.usedPages);
        }
        return sb.toString();
    }

    private void dirty() {
        if (this.fPreIndex == null) {
            int i;
            this.fPreIndex = new int[this.pages];
            for (i = 0; i < this.pages; ++i) {
                this.fPreIndex[i] = i * 256;
            }
            this.pageIndex = new int[this.pages];
            for (i = 0; i < this.pages; ++i) {
                this.pageIndex[i] = i;
            }
            this.usedPages = new BitArray(this.used, true);
        }
        this.dirty = true;
    }

    private int cursor(int pre) {
        int fp = this.firstPre;
        int np = this.nextPre;
        if (pre < fp || pre >= np) {
            int last = this.used - 1;
            int l = 0;
            int h = last;
            int m = this.page;
            while (l <= h) {
                if (pre < fp) {
                    h = m - 1;
                } else {
                    if (pre < np) break;
                    l = m + 1;
                }
                m = h + l >>> 1;
                fp = this.fpre(m);
                np = m == last ? this.meta.size : this.fpre(m + 1);
            }
            if (l > h) {
                throw Util.notExpected("Data Access out of bounds:\n- PRE value: " + pre + "\n- table size: " + this.meta.size + "\n- first/next PRE value: " + fp + "/" + np + "\n- #total/used pages: " + this.pages + "/" + this.used + "\n- accessed page: " + m + " (" + l + " > " + h + "]", new Object[0]);
            }
            this.readPage(m);
        }
        return pre - this.firstPre << 4;
    }

    private void setPage(int pre) {
        this.page = pre;
        this.firstPre = this.fpre(pre);
        this.nextPre = pre + 1 >= this.used ? this.meta.size : this.fpre(pre + 1);
    }

    private void readPage(int pre) {
        this.setPage(pre);
        this.read(this.pageIndex == null ? pre : this.pageIndex[pre]);
    }

    private int fpre(int pre) {
        return this.fPreIndex == null ? pre * 256 : this.fPreIndex[pre];
    }

    private void read(int pre) {
        if (!this.buffers.cursor(pre)) {
            return;
        }
        Buffer buffer = this.buffers.current();
        try {
            this.write(buffer);
            buffer.pos = pre;
            if (pre >= this.pages) {
                this.pages = pre + 1;
            } else {
                this.file.seek(buffer.pos << 12);
                this.file.readFully(buffer.data);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(Util.info(ex, new Object[0]));
        }
    }

    private void write(Buffer buffer) throws IOException {
        if (!buffer.dirty) {
            return;
        }
        this.file.seek(buffer.pos << 12);
        this.file.write(buffer.data);
        buffer.dirty = false;
    }

    private void deletePages(int count) {
        Array.remove(this.fPreIndex, this.page, count, this.used);
        Array.remove(this.pageIndex, this.page, count, this.used);
        this.used -= count;
    }

    private void decreasePre(int count) {
        int nextPage;
        int i = nextPage = this.page + 1;
        while (i < this.used) {
            int n = i++;
            this.fPreIndex[n] = this.fPreIndex[n] - count;
        }
        this.meta.size -= count;
        this.nextPre = nextPage < this.used && this.fPreIndex[nextPage] < this.meta.size ? this.fPreIndex[nextPage] : this.meta.size;
    }

    private static void delete(Buffer buffer, int from, int to, int length) {
        byte[] array = buffer.data;
        Array.copy(array, to << 4, length << 4, array, from << 4);
        buffer.dirty = true;
    }

    private int write(byte[] array, int offset) {
        Buffer buffer = this.buffers.current();
        int len = Math.min(4096, array.length - offset);
        Array.copyToStart(array, offset, len, buffer.data);
        buffer.dirty = true;
        return len;
    }

    private int occSpace(int index) {
        return (index + 1 < this.used ? this.fPreIndex[index + 1] : this.meta.size) - this.fPreIndex[index];
    }

    private void removeMapping() {
        this.fPreIndex = null;
        this.pageIndex = null;
        this.usedPages = null;
    }
}

