/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.transform.stream.StreamSource;
import org.basex.core.Databases;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.BufferInput;
import org.basex.io.in.TextInput;
import org.basex.io.out.BufferOutput;
import org.basex.util.FTToken;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public abstract class IO {
    public static final String TMPSUFFIX = ".tmp";
    public static final String BASEXSUFFIX = ".basex";
    public static final String BXSSUFFIX = ".bxs";
    public static final String XQSUFFIX = ".xq";
    public static final String XQMSUFFIX = ".xqm";
    public static final String XMLSUFFIX = ".xml";
    public static final String ZIPSUFFIX = ".zip";
    public static final String CSVSUFFIX = ".csv";
    public static final String JSONSUFFIX = ".json";
    public static final String JARSUFFIX = ".jar";
    public static final String TARGZSUFFIX = ".tar.gz";
    public static final String TGZSUFFIX = ".tgz";
    public static final String GZSUFFIX = ".gz";
    public static final String TARSUFFIX = ".tar";
    public static final String XARSUFFIX = ".xar";
    public static final String LOGSUFFIX = ".log";
    public static final String IGNORESUFFIX = ".ignore";
    public static final String FILEPREF = "file:/";
    public static final String JARPREF = "jar:";
    public static final String[] XQSUFFIXES = new String[]{".xq", ".xqm", ".xqy", ".xql", ".xqu", ".xquery", ".xpath"};
    public static final String[] ARCHIVESUFFIXES = new String[]{".zip", ".gz", ".tgz", ".tar", ".xar", ".docx", ".pptx", ".xlsx", ".odt", ".odp", ".ods", ".epub", ".idml"};
    public static final String[] XSLSUFFIXES = new String[]{".xsl", ".xslt", ".fo", ".fob"};
    public static final String[] HTMLSUFFIXES = new String[]{".html", ".htm"};
    public static final String[] TXTSUFFIXES = new String[]{".txt", ".text", ".ini", ".conf", ".md", ".log"};
    public static final String[] JSSUFFIXES = new String[]{".js", ".java", ".ts", ".vue"};
    public static final int BLOCKPOWER = 12;
    public static final int BLOCKSIZE = 4096;
    public static final int NODEPOWER = 4;
    public static final int NODESIZE = 16;
    public static final int ENTRIES = 256;
    public static final int MAXATTS = 31;
    protected String pth;
    protected long len = -1L;
    private String nm;

    IO(String path, boolean single) {
        this.pth = path;
        this.nm = single && path.endsWith("/") ? "" : path.replaceAll("^(?:.*/)?([^/]+)/?$", "$1");
    }

    public static IO get(String location) {
        if (location == null) {
            return new IOContent("");
        }
        String s = location.trim();
        return s.indexOf(60) == 0 ? new IOContent(s) : (IOUrl.isFileURL(s) ? new IOFile(IOFile.toPath(s)) : (IOUrl.isValid(s) ? new IOUrl(s) : (IOFile.isValid(s) ? new IOFile(s) : new IOContent(s))));
    }

    public abstract byte[] read() throws IOException;

    public final String readString() throws IOException {
        return new TextInput(this).cache().toString();
    }

    public boolean exists() {
        return true;
    }

    public boolean isDir() {
        return Strings.endsWith(this.pth, '/');
    }

    public boolean isAbsolute() {
        return true;
    }

    public final boolean hasSuffix(String ... suffixes) {
        return IO.checkSuffix(this.pth, suffixes);
    }

    public long timeStamp() {
        return System.currentTimeMillis();
    }

    public final void length(long length) {
        this.len = length;
    }

    public long length() {
        return this.len;
    }

    public abstract InputSource inputSource();

    public abstract StreamSource streamSource();

    public abstract InputStream inputStream() throws IOException;

    public String encoding() {
        return null;
    }

    public final IO merge(String path) {
        if (path.isEmpty()) {
            return this;
        }
        IO io = IO.get(path);
        if (io.isAbsolute()) {
            return io;
        }
        if (IOUrl.isJarURL(this.pth)) {
            try {
                return IO.get(new URL(new URL(this.pth), path).toString());
            }
            catch (MalformedURLException ex) {
                Util.stack(ex);
            }
        }
        return IO.get((Strings.endsWith(this.pth, '/') ? this.pth : this.dir()) + path);
    }

    public final boolean isArchive() {
        return this.hasSuffix(ARCHIVESUFFIXES);
    }

    public final String dbName() {
        TokenBuilder tb = new TokenBuilder();
        byte[] token = Token.token(this.name());
        int nl = Token.lastIndexOf(token, 46);
        if (nl == -1) {
            nl = token.length;
        }
        for (int n = 0; n < nl; n += Token.cl(token, n)) {
            int ch = FTToken.noDiacritics(Token.cp(token, n));
            if (!Databases.validChar(ch, n == 0 || n + 1 == nl)) continue;
            tb.add(ch);
        }
        return tb.isEmpty() ? Integer.toString(this.hashCode()) : tb.toString();
    }

    public final String name() {
        return this.nm;
    }

    public final void name(String name) {
        this.nm = name;
        if (this.pth.isEmpty()) {
            this.pth = name;
        }
    }

    public final String path() {
        return this.pth;
    }

    public final String dir() {
        return this.pth.substring(0, this.pth.lastIndexOf(47) + 1);
    }

    public String url() {
        return this.pth;
    }

    public boolean eq(IO io) {
        return this.pth.equals(io.pth);
    }

    public String toString() {
        return this.pth;
    }

    public static boolean checkSuffix(String path, String ... suffixes) {
        int i = path.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String suf = path.substring(i).toLowerCase(Locale.ENGLISH);
        for (String suffix : suffixes) {
            if (!suf.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static void write(InputStream in, OutputStream out) throws IOException {
        try (BufferInput bi = BufferInput.get(in);
             BufferOutput bo = BufferOutput.get(out);){
            int c;
            while ((c = bi.read()) != -1) {
                bo.write(c);
            }
        }
    }

    public static boolean equals(String string1, String string2) {
        return Prop.CASE ? string1.equals(string2) : string1.equalsIgnoreCase(string2);
    }
}

