/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.awt.Color;
import java.awt.Graphics;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;
import org.basex.gui.view.map.MapRenderer;
import org.basex.gui.view.map.MapView;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.value.seq.DBNodes;

final class MapPainter {
    private final MapView view;
    private final GUIOptions gopts;

    MapPainter(MapView view, GUIOptions gopts) {
        this.view = view;
        this.gopts = gopts;
    }

    private Color color(MapRects rects, int ri, Data data) {
        int pre;
        int m;
        DBNodes marked = this.view.gui.context.marked;
        if (marked != null && (m = -marked.find(pre = rects.get((int)ri).pre) - 1) >= 0) {
            int r = rects.find(pre);
            if ((long)m < marked.size()) {
                int e;
                if (r + 1 < rects.size) {
                    e = rects.sorted[r + 1].pre;
                } else {
                    int spre = rects.sorted[r].pre;
                    e = data.size(spre, data.kind(spre));
                }
                return marked.sorted(m) < e ? GUIConstants.colormark2 : null;
            }
            return null;
        }
        return GUIConstants.colormark1;
    }

    void drawRectangles(Graphics g, MapRects rects) {
        MapRenderer renderer = new MapRenderer(g);
        MapRect l = this.view.layout.layout;
        int ww = this.view.getWidth();
        int hh = this.view.getHeight();
        Data data = this.view.gui.context.data();
        FTPosData ftpos = this.view.gui.context.marked.ftpos();
        int o = this.gopts.get(GUIOptions.MAPOFFSETS);
        int rs = rects.size;
        for (int ri = 0; ri < rs; ++ri) {
            MapRect rect = rects.get(ri);
            int pre = rect.pre;
            int lvl = rect.level;
            boolean full = rect.w == ww && rect.h == hh;
            Color col = this.color(rects, ri, data);
            boolean mark = col != null;
            rect.pos = ftpos != null ? ftpos.get(data, pre) : null;
            g.setColor(mark ? col : GUIConstants.color(lvl));
            if (rect.w < l.x + l.w || rect.h < l.y + l.h || o < 2 || ViewData.leaf(this.gopts, data, pre)) {
                g.fillRect(rect.x, rect.y, rect.w, rect.h);
            } else {
                g.fillRect(rect.x, rect.y, l.x, rect.h);
                g.fillRect(rect.x, rect.y, rect.w, l.y);
                g.fillRect(rect.x + rect.w - l.w, rect.y, l.w, rect.h);
                g.fillRect(rect.x, rect.y + rect.h - l.h, rect.w, l.h);
            }
            if (!full) {
                col = mark ? GUIConstants.colormark3 : GUIConstants.color(lvl + 2);
                g.setColor(col);
                g.drawRect(rect.x, rect.y, rect.w, rect.h);
                col = mark ? GUIConstants.colormark4 : GUIConstants.color(Math.max(0, lvl - 2));
                g.setColor(col);
                g.drawLine(rect.x + rect.w, rect.y, rect.x + rect.w, rect.y + rect.h);
                g.drawLine(rect.x, rect.y + rect.h, rect.x + rect.w, rect.y + rect.h);
            }
            if (rect.w <= 3 || rect.h < GUIConstants.fontSize) continue;
            rect.x += 3;
            rect.w -= 3;
            int kind = data.kind(pre);
            if (kind == 1 || kind == 0) {
                g.setColor(GUIConstants.TEXT);
                g.setFont(GUIConstants.font);
                renderer.chopText(ViewData.label(this.gopts, data, pre), rect.x, rect.y, rect.w);
            } else {
                g.setColor(GUIConstants.color((rect.level << 1) + 8));
                g.setFont(GUIConstants.mfont);
                byte[] text = ViewData.text(data, pre);
                boolean bl = rect.thumb = renderer.calcHeight(rect, text) >= rect.h;
                if (rect.thumb) {
                    renderer.drawThumbnails(rect, text);
                } else {
                    renderer.drawText(rect, text);
                }
            }
            rect.x -= 3;
            rect.w += 3;
        }
    }

    static byte[] text(Data data, MapRect mr) {
        return ViewData.text(data, mr.pre);
    }
}

