/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogFT;
import org.basex.gui.dialog.DialogIndex;
import org.basex.gui.dialog.DialogOptions;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogPut;
import org.basex.gui.dialog.DialogResources;
import org.basex.gui.dialog.DialogValues;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.index.IndexType;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DialogProps
extends BaseXDialog {
    private static final String[] HELP = new String[]{"", "", Text.H_PATH_INDEX, Text.H_TEXT_INDEX, Text.H_ATTR_INDEX, Text.H_TOKEN_INDEX, ""};
    private static final IndexType[] TYPES = new IndexType[]{IndexType.ELEMNAME, IndexType.ATTRNAME, IndexType.PATH, IndexType.TEXT, IndexType.ATTRIBUTE, IndexType.TOKEN, IndexType.FULLTEXT};
    private static final String[] LABELS = new String[]{Text.ELEMENTS, Text.ATTRIBUTES, Text.PATH_INDEX, Text.TEXT_INDEX, Text.ATTRIBUTE_INDEX, Text.TOKEN_INDEX, Text.FULLTEXT_INDEX};
    private final BaseXBack ftPanel;
    private final BaseXBack namesPanel;
    private final BaseXBack pathsPanel;
    private final BaseXBack indexesPanel;
    private final IntList updated = new IntList();
    private final BaseXTabs tabs;
    private final DialogOptions optionsPanel;
    private final TextPanel[] infos = new TextPanel[LABELS.length];
    private final TextPanel dbInfo;
    private final TextPanel nsInfo;
    private final BaseXButton optimize;
    private final BaseXButton optimizeAll;
    private final BaseXLabel[] labels = new BaseXLabel[LABELS.length];
    private final BaseXButton[] buttons = new BaseXButton[LABELS.length];
    private final BaseXBack[] panels = new BaseXBack[LABELS.length];
    private final DialogIndex[] indexes = new DialogIndex[LABELS.length];
    DialogPut addPanel;
    DialogResources resources;

    public DialogProps(GUI gui) {
        super(gui, Text.DB_PROPS);
        int l;
        this.panel.setLayout(new BorderLayout(5, 0));
        this.resources = new DialogResources(this);
        this.resources.setPreferredSize(new Dimension(300, 1));
        this.set(this.resources, "West");
        this.addPanel = new DialogPut(this);
        this.addPanel.border(8);
        int ll = LABELS.length;
        for (l = 0; l < ll; ++l) {
            this.labels[l] = new BaseXLabel(LABELS[l]).large();
            this.panels[l] = new BaseXBack(new BorderLayout(0, 4));
            BaseXLayout.setWidth(this.panels[l], 600);
            this.infos[l] = new TextPanel(this, Text.PLEASE_WAIT_D, false);
            this.infos[l].setFont(GUIConstants.dmfont);
        }
        for (l = IndexType.TEXT.ordinal(); l < ll; ++l) {
            this.buttons[l] = new BaseXButton(this, " ");
            BaseXLayout.setHeight(this.panels[l], 160);
        }
        Data data = gui.context.data();
        this.buttons[IndexType.FULLTEXT.ordinal()].setEnabled(!data.inMemory());
        this.indexes[IndexType.TEXT.ordinal()] = new DialogValues(this, IndexType.TEXT);
        this.indexes[IndexType.ATTRIBUTE.ordinal()] = new DialogValues(this, IndexType.ATTRIBUTE);
        this.indexes[IndexType.TOKEN.ordinal()] = new DialogValues(this, IndexType.TOKEN);
        this.indexes[IndexType.FULLTEXT.ordinal()] = new DialogFT(this, false);
        this.namesPanel = new BaseXBack(new GridLayout(2, 1, 0, 8)).border(8);
        this.namesPanel.add(this.panels[IndexType.ELEMNAME.ordinal()]);
        this.namesPanel.add(this.panels[IndexType.ATTRNAME.ordinal()]);
        this.pathsPanel = this.panels[IndexType.PATH.ordinal()].border(8);
        this.indexesPanel = new BaseXBack(new GridLayout(3, 1, 0, 8)).border(8);
        this.indexesPanel.add(this.panels[IndexType.TEXT.ordinal()]);
        this.indexesPanel.add(this.panels[IndexType.ATTRIBUTE.ordinal()]);
        this.indexesPanel.add(this.panels[IndexType.TOKEN.ordinal()]);
        this.ftPanel = this.panels[IndexType.FULLTEXT.ordinal()].border(8);
        BaseXBack infoPanel = new BaseXBack(new GridLayout(2, 1)).border(8);
        BaseXBack dbPanel = new BaseXBack(new BorderLayout());
        BaseXLabel db = new BaseXLabel().border(0, 0, 6, 0).large();
        dbPanel.add((Component)db.setChoppedText(Text.DATABASE + ": " + data.meta.name, 600), "North");
        this.dbInfo = new TextPanel(this, "", false);
        this.dbInfo.setFont(infoPanel.getFont());
        this.dbInfo.setPreferredSize(new Dimension(600, 1));
        dbPanel.add((Component)new SearchEditor(gui, this.dbInfo), "Center");
        BaseXBack nsPanel = new BaseXBack(new BorderLayout());
        nsPanel.add((Component)new BaseXLabel(Text.NAMESPACES).border(0, 0, 6, 0).large(), "North");
        this.nsInfo = new TextPanel(this, "", false);
        this.nsInfo.setPreferredSize(new Dimension(600, 1));
        nsPanel.add((Component)new SearchEditor(gui, this.nsInfo), "Center");
        infoPanel.add(dbPanel);
        infoPanel.add(nsPanel);
        this.optionsPanel = new DialogOptions(this, data);
        BaseXBack tabsPanel = new BaseXBack(new BorderLayout());
        this.tabs = new BaseXTabs(this);
        this.tabs.addTab(Text.RESOURCES, this.addPanel);
        this.tabs.addTab(Text.NAMES, this.namesPanel);
        this.tabs.addTab(Text.PATHS, this.pathsPanel);
        this.tabs.addTab(Text.INDEXES, this.indexesPanel);
        this.tabs.addTab(Text.FULLTEXT, this.ftPanel);
        this.tabs.addTab(Text.OPTIONS, this.optionsPanel);
        this.tabs.addTab(Text.INFORMATION, infoPanel);
        this.tabs.addChangeListener(evt -> this.updateInfo());
        tabsPanel.add((Component)this.tabs, "Center");
        this.optimize = new BaseXButton(this, Text.OPTIMIZE);
        this.optimizeAll = new BaseXButton(this, Text.OPTIMIZE_ALL);
        this.optimizeAll.setEnabled(!gui.context.data().inMemory());
        tabsPanel.add((Component)this.newButtons(this.optimize, this.optimizeAll), "South");
        this.set(tabsPanel, "Center");
        this.action(this);
        this.setResizable(true);
        this.finish();
    }

    private synchronized void updateInfo() {
        Component o = this.tabs.getSelectedComponent();
        IntList il = new IntList();
        if (o == this.namesPanel) {
            il.add(IndexType.ELEMNAME.ordinal());
            il.add(IndexType.ATTRNAME.ordinal());
        } else if (o == this.pathsPanel) {
            il.add(IndexType.PATH.ordinal());
        } else if (o == this.indexesPanel) {
            il.add(IndexType.TEXT.ordinal());
            il.add(IndexType.ATTRIBUTE.ordinal());
            il.add(IndexType.TOKEN.ordinal());
        } else if (o == this.ftPanel) {
            il.add(IndexType.FULLTEXT.ordinal());
        }
        Data data = this.gui.context.data();
        boolean[] val = new boolean[]{true, true, true, data.meta.textindex, data.meta.attrindex, data.meta.tokenindex, data.meta.ftindex};
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            int idx = il.get(i);
            if (this.updated.contains(idx)) continue;
            this.updated.add(idx);
            SwingUtilities.invokeLater(() -> {
                this.infos[idx].setText(val[idx] ? data.info(TYPES[idx], this.gui.context.options) : Token.token(HELP[idx]));
                this.updated.removeAll(idx);
            });
        }
    }

    private void add(int i, BaseXBack alt) {
        BaseXBack header = new BaseXBack(new BorderLayout(8, 0));
        header.add((Component)this.labels[i], "West");
        if (this.buttons[i] != null) {
            header.add((Component)this.buttons[i], "East");
        }
        this.panels[i].removeAll();
        this.panels[i].add((Component)header, "North");
        this.panels[i].add((Component)(alt != null ? alt : new SearchEditor(this.gui, this.infos[i])), "Center");
        this.panels[i].revalidate();
        this.panels[i].repaint();
    }

    @Override
    public void action(Object cmp) {
        boolean outofdate;
        if (this.resources == null) {
            return;
        }
        Data data = this.gui.context.data();
        boolean[] exists = new boolean[]{true, true, true, data.meta.textindex, data.meta.attrindex, data.meta.tokenindex, data.meta.ftindex};
        ACreate cmd = null;
        if (cmp == this.optimize) {
            cmd = new Optimize();
        } else if (cmp == this.optimizeAll) {
            cmd = new OptimizeAll();
            this.optionsPanel.setOptions(data);
        } else {
            int bl = this.buttons.length;
            for (int b = 0; b < bl; ++b) {
                if (cmp != this.buttons[b]) continue;
                if (exists[b]) {
                    cmd = new DropIndex((Object)TYPES[b]);
                } else {
                    cmd = new CreateIndex((Object)TYPES[b]);
                    this.indexes[b].setOptions();
                }
                this.infos[b].setText(Text.PLEASE_WAIT_D);
            }
        }
        if (cmd != null) {
            DialogProgress.execute((BaseXDialog)this, cmd);
            return;
        }
        this.resources.action(cmp);
        this.addPanel.action(cmp);
        boolean bl = outofdate = !data.meta.uptodate;
        if (cmp == this) {
            int ll = LABELS.length;
            for (int l = 0; l < ll; ++l) {
                this.labels[l].setText((String)(l < IndexType.TEXT.ordinal() && outofdate ? LABELS[l] + " (" + Text.OUT_OF_DATE + ")" : LABELS[l]));
                if (this.buttons[l] != null) {
                    this.buttons[l].setText(exists[l] ? Text.DROP : Text.CREATE);
                }
                this.add(l, this.indexes[l] == null || exists[l] ? null : this.indexes[l]);
            }
            this.updateInfo();
        }
        for (DialogIndex index : this.indexes) {
            if (index == null) continue;
            index.action(true);
        }
        this.dbInfo.setText(InfoDB.db(data.meta, true, false));
        this.nsInfo.setText(data.nspaces.info());
        this.optimize.setEnabled(outofdate);
        this.optimizeAll.setEnabled(!data.inMemory());
    }

    @Override
    public void close() {
        for (DialogIndex index : this.indexes) {
            if (index == null) continue;
            index.setOptions();
        }
        super.close();
    }

    @Override
    public void dispose() {
        this.resources = null;
        this.addPanel = null;
        super.dispose();
    }
}

