/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.users;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.core.users.UserText;
import org.basex.io.IOFile;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLAccess;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;
import org.basex.util.log.LogType;

public final class Users {
    private final LinkedHashMap<String, User> users = new LinkedHashMap();
    private final IOFile file;
    private ANode info;

    public Users(StaticOptions sopts) {
        this.file = sopts.dbPath(Token.string(UserText.Q_USERS.string()) + ".xml");
        this.read();
        if (this.get("admin") == null) {
            this.add(new User("admin").permission(Perm.ADMIN));
        }
    }

    private synchronized void read() {
        if (!this.file.exists()) {
            return;
        }
        try {
            MainOptions options = new MainOptions(false);
            options.set(MainOptions.INTPARSE, true);
            options.set(MainOptions.STRIPWS, true);
            DBNode doc = new DBNode(Parser.singleParser(this.file, options, ""));
            ANode root = XMLAccess.children(doc, UserText.Q_USERS).next();
            if (root == null) {
                Util.errln("%: No <%/> root element.", this.file, UserText.Q_USERS);
            } else {
                for (ANode child : XMLAccess.children(root)) {
                    QNm qname = child.qname();
                    if (qname.eq(UserText.Q_USER)) {
                        try {
                            User user = new User(child, this.file);
                            String name = user.name();
                            if (this.users.get(name) != null) {
                                Util.errln("%: User '%' supplied more than once.", this.file, name);
                                continue;
                            }
                            this.users.put(name, user);
                        }
                        catch (BaseXException ex) {
                            Util.errln("%: %", this.file, ex.getLocalizedMessage());
                        }
                        continue;
                    }
                    if (qname.eq(UserText.Q_INFO)) {
                        if (this.info != null) {
                            Util.errln("%: <%/> occurs more than once.", this.file, qname);
                            continue;
                        }
                        this.info = child.finish();
                        continue;
                    }
                    Util.errln("%: invalid element <%/>.", this.file, qname);
                }
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    public synchronized void write() {
        try {
            this.file.parent().md();
            FBuilder root = FElem.build(UserText.Q_USERS);
            for (User user : this.users.values()) {
                root.add(user.toXml(null, null));
            }
            if (this.info != null) {
                root.add(this.info);
                this.info.parent(null);
            }
            this.file.write(root.finish().serialize(SerializerMode.INDENT.get()).finish());
        }
        catch (IOException | QueryException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    public synchronized void init(Context ctx) {
        if (this.file.exists()) {
            return;
        }
        String pw = UUID.randomUUID().toString();
        this.get("admin").password(pw);
        this.write();
        ctx.log.writeServer(LogType.INFO, "Initial admin password (change after first login): " + pw);
    }

    public synchronized void add(User user) {
        this.users.put(user.name(), user);
    }

    public synchronized void alter(User user, String name) {
        this.users.remove(user.name());
        user.name(name);
        this.users.put(name, user);
    }

    public synchronized void drop(User user) {
        this.users.remove(user.name());
    }

    public synchronized User get(String name) {
        return this.users.get(name);
    }

    public synchronized String[] find(Pattern pattern) {
        StringList sl = new StringList();
        for (String name : this.users.keySet()) {
            if (!pattern.matcher(name).matches()) continue;
            sl.add(name);
        }
        return (String[])sl.finish();
    }

    public synchronized Table info(String db, Context ctx) {
        Table table = new Table();
        table.description = Text.USERS_X;
        for (String user : UserText.S_USERINFO) {
            table.header.add(user);
        }
        for (User user : this.users(db, ctx)) {
            table.contents.add(new TokenList().add(user.name()).add(user.permission(db).toString()));
        }
        return table.sort().toTop(Token.token("admin"));
    }

    public synchronized ArrayList<User> users(String db, Context ctx) {
        User curr = ctx.user();
        boolean admin = curr.has(Perm.ADMIN);
        ArrayList<User> list = new ArrayList<User>();
        for (User user : this.users.values()) {
            if (!admin && curr != user) continue;
            if (db == null) {
                list.add(user);
                continue;
            }
            Map.Entry<String, Perm> entry = user.find(db);
            if (entry == null) continue;
            list.add(user);
        }
        return list;
    }

    public synchronized ANode info() {
        return this.info;
    }

    public synchronized void info(ANode elem) {
        this.info = elem.hasChildren() || elem.hasAttributes() ? elem : null;
    }
}

