/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.data.MetaProp;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

public final class InfoDB
extends AInfo {
    public InfoDB() {
        super(true, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        this.out.print(InfoDB.db(this.context.data().meta, false, true));
        return true;
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("internal:context");
    }

    public static String db(MetaData meta, boolean bold, boolean index) {
        TokenBuilder tb = new TokenBuilder();
        String header = (bold ? new TokenBuilder().bold().add(37).norm().toString() : "%") + Text.NL;
        tb.addExt(header, Text.DB_PROPS);
        InfoDB.info(tb, MetaProp.NAME, meta);
        InfoDB.info(tb, MetaProp.SIZE.name(), Performance.formatHuman(meta.dbSize()));
        InfoDB.info(tb, MetaProp.NODES, meta);
        InfoDB.info(tb, MetaProp.DOCUMENTS, meta);
        InfoDB.info(tb, MetaProp.BINARIES, meta);
        InfoDB.info(tb, MetaProp.VALUES, meta);
        InfoDB.info(tb, MetaProp.TIMESTAMP, meta);
        InfoDB.info(tb, MetaProp.UPTODATE, meta);
        if (meta.corrupt) {
            tb.add(" " + Text.DB_CORRUPT + Text.NL);
        }
        tb.add(Text.NL).addExt(header, Text.RES_PROPS);
        InfoDB.info(tb, MetaProp.INPUTPATH, meta);
        InfoDB.info(tb, MetaProp.INPUTSIZE.name(), Performance.formatHuman(meta.inputsize));
        InfoDB.info(tb, MetaProp.INPUTDATE, meta);
        if (index) {
            tb.add(Text.NL).addExt(header, Text.INDEXES);
            if (meta.oldindex()) {
                tb.add(" " + Text.H_INDEX_FORMAT + Text.NL);
            } else {
                for (MetaProp prop : MetaProp.values()) {
                    if (!prop.index) continue;
                    InfoDB.info(tb, prop, meta);
                }
            }
        }
        return tb.toString();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.INFO) + " " + String.valueOf((Object)Commands.CmdInfo.DB));
    }
}

