/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.cmd.AQuery;
import org.basex.query.expr.path.Axis;
import org.basex.util.Array;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.list.BoolList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class Find
extends AQuery {
    public Find(String search) {
        super(true, search, Find.query(search));
    }

    public static String query(String search) {
        if (search.isEmpty()) {
            return ".";
        }
        if (Strings.startsWith(search, '/')) {
            return search;
        }
        StringBuilder pre = new StringBuilder();
        StringBuilder preds = new StringBuilder();
        for (String term : Find.split(search.replace(" +", " "))) {
            if (term.startsWith("@=")) {
                preds.append("[@* = \"").append(term.substring(2)).append("\"]");
                continue;
            }
            if (Strings.startsWith(term, '=')) {
                preds.append("[text() = \"").append(term.substring(1)).append("\"]");
                continue;
            }
            if (Strings.startsWith(term, '~')) {
                preds.append("[text() contains text \"").append(term.substring(1));
                preds.append("\" using fuzzy]");
                continue;
            }
            if (Strings.startsWith(term, '@')) {
                if (term.length() == 1) continue;
                preds.append("[@* contains text \"").append(term.substring(1)).append("\"]");
                term = term.substring(1);
                if (!XMLToken.isName(Token.token(term))) continue;
                pre.append(".//@").append(term).append(" | ");
                continue;
            }
            preds.append("[text() contains text \"").append(term).append("\"]");
            if (!XMLToken.isName(Token.token(term))) continue;
            pre.append((Object)Axis.DESCENDANT).append("::*:").append(term).append(" | ");
        }
        if (pre.isEmpty() && preds.isEmpty()) {
            return ".";
        }
        return pre.append((Object)Axis.DESCENDANT_OR_SELF).append("::*").append((CharSequence)preds).toString();
    }

    public static String tableQuery(StringList filter, TokenList cols, BoolList elem, String name, boolean root) {
        TokenBuilder tb = new TokenBuilder();
        int is = filter.size();
        for (int i = 0; i < is; ++i) {
            String[] spl;
            for (String s : spl = Find.split((String)filter.get(i))) {
                byte[] term = Token.trim(Token.replace(Token.token(s), 34, 32));
                if (term.length == 0) continue;
                boolean elm = elem.get(i);
                tb.add(91).add(elm ? ".//" : "@").add("*:").add((byte[])cols.get(i));
                if (term[0] == 60 || term[0] == 62) {
                    tb.add(term[0]).addLong(Find.sizeToLong(Token.substring(term, 1)));
                } else {
                    tb.add(" contains text \"").add(term).add(34);
                }
                tb.add(93);
            }
        }
        return tb.isEmpty() ? "/" : (root ? "/" : "") + String.valueOf((Object)Axis.DESCENDANT_OR_SELF) + "::*:" + name + String.valueOf(tb);
    }

    private static long sizeToLong(byte[] token) {
        long i;
        int s2;
        int tl = token.length;
        int f = 0;
        int s1 = tl < 1 ? 0 : Token.lc(token[tl - 1]);
        int n = s2 = tl < 2 ? 0 : Token.lc(token[tl - 2]);
        if (s1 == 107) {
            --tl;
            f = 10;
        }
        if (s1 == 109) {
            --tl;
            f = 20;
        }
        if (s1 == 103) {
            --tl;
            f = 30;
        }
        if (s1 == 98 && s2 == 107) {
            tl -= 2;
            f = 10;
        }
        if (s1 == 98 && s2 == 109) {
            tl -= 2;
            f = 20;
        }
        if (s1 == 98 && s2 == 103) {
            tl -= 2;
            f = 30;
        }
        return (i = Token.toLong(token, 0, tl) << f) == Long.MIN_VALUE ? 0L : i;
    }

    private static String[] split(String string) {
        int l = string.length();
        String[] split = new String[l];
        int s = 0;
        char delim = '\u0000';
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (delim == '\u0000') {
                if (c == '\'' || c == '\"') {
                    delim = c;
                    continue;
                }
                if (!XMLToken.isChar(c) && c != '@' && c != '=' && c != '<' && c != '>' && c != '~') {
                    if (sb.isEmpty()) continue;
                    split[s++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == delim) {
                delim = '\u0000';
                if (sb.isEmpty()) continue;
                split[s++] = sb.toString();
                sb.setLength(0);
                continue;
            }
            if (c == '\'' || c == '\"') continue;
            sb.append(c);
        }
        if (!sb.isEmpty()) {
            split[s++] = sb.toString();
        }
        return Array.copyOf(split, s);
    }
}

