/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.util.Random;
import org.basex.core.CLI;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.Test;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.ConsoleReader;
import org.basex.util.MainParser;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;

public class BaseX
extends CLI {
    private static final String PROMPT = "> ";
    private IntList ops;
    private StringList vals;
    private volatile boolean console;

    public static void main(String ... args) {
        try {
            new BaseX(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseX(String ... args) throws IOException {
        super(new Context(), args);
        this.session();
        this.console = true;
        try {
            StringBuilder bind = new StringBuilder();
            SerializerOptions sopts = null;
            boolean v = false;
            boolean qi = false;
            boolean qp = false;
            int os = this.ops.size();
            for (int o = 0; o < os; ++o) {
                int c = this.ops.get(o);
                String value = (String)this.vals.get(o);
                switch (c) {
                    case 98: {
                        if (!bind.isEmpty()) {
                            bind.append(',');
                        }
                        value = bind.append(value.replace(",", ",,")).toString();
                        this.execute(new Set(MainOptions.BINDINGS, value), false);
                        break;
                    }
                    case 99: {
                        this.console = false;
                        if (this.execute(BaseX.commands(value))) break;
                        return;
                    }
                    case 67: {
                        this.console = false;
                        if (this.execute(BaseX.script(value))) break;
                        return;
                    }
                    case 105: {
                        this.execute(new Set(MainOptions.MAINMEM, true), false);
                        this.execute(new Check(value), this.verbose);
                        this.execute(new Set(MainOptions.MAINMEM, false), false);
                        break;
                    }
                    case 73: {
                        if (!bind.isEmpty()) {
                            bind.append(',');
                        }
                        value = bind.append('=').append(value.replace(",", ",,")).toString();
                        this.execute(new Set(MainOptions.BINDINGS, value), false);
                        break;
                    }
                    case 111: {
                        if (this.out != System.out) {
                            this.out.close();
                        }
                        this.out = new PrintOutput(new IOFile(value));
                        this.session().setOutputStream(this.out);
                        break;
                    }
                    case 79: {
                        String[] kv = value.split("=", 2);
                        this.execute(new Set(kv[0], (Object)(kv.length > 1 ? kv[1] : "")), false);
                        break;
                    }
                    case 113: {
                        this.console = false;
                        this.execute(new XQuery(value), this.verbose);
                        break;
                    }
                    case 81: {
                        this.console = false;
                        IO io = IO.get(value);
                        this.execute(new XQuery(io.readString()).baseURI(io.path()), this.verbose);
                        break;
                    }
                    case 114: {
                        this.execute(new Set(MainOptions.RUNS, Strings.toInt(value)), false);
                        break;
                    }
                    case 82: {
                        this.execute(new Set(MainOptions.RUNQUERY, null), false);
                        break;
                    }
                    case 115: {
                        if (sopts == null) {
                            sopts = new SerializerOptions();
                        }
                        String[] kv = value.split("=", 2);
                        sopts.assign(kv[0], kv.length > 1 ? kv[1] : "");
                        this.execute(new Set(MainOptions.SERIALIZER, sopts), false);
                        break;
                    }
                    case 116: {
                        this.console = false;
                        this.execute(new Test(value), this.verbose);
                        break;
                    }
                    case 117: {
                        this.execute(new Set(MainOptions.WRITEBACK, null), false);
                        break;
                    }
                    case 118: {
                        v ^= true;
                        break;
                    }
                    case 86: {
                        qi ^= true;
                        this.execute(new Set(MainOptions.QUERYINFO, null), false);
                        break;
                    }
                    case 119: {
                        this.execute(new Set(MainOptions.STRIPWS, null), false);
                        break;
                    }
                    case 87: {
                        if (sopts == null) {
                            sopts = new SerializerOptions();
                        }
                        sopts.set(SerializerOptions.INDENT, Options.YesNo.YES);
                        this.execute(new Set(MainOptions.SERIALIZER, sopts), false);
                        break;
                    }
                    case 120: {
                        this.execute(new Set(MainOptions.XMLPLAN, null), false);
                        qp ^= true;
                        break;
                    }
                    case 122: {
                        this.execute(new Set(MainOptions.SERIALIZE, null), false);
                    }
                }
                this.verbose = qi || qp || v;
            }
            if (this.console) {
                this.console();
            }
        }
        finally {
            this.quit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void console() {
        Util.println(this.header() + Text.NL + Text.TRY_MORE_X, new Object[0]);
        this.verbose = true;
        try (ConsoleReader cr = ConsoleReader.get();){
            while (this.console) {
                String in = cr.readLine(PROMPT);
                if (in == null) {
                    return;
                }
                if (in.isEmpty()) continue;
                try {
                    if (this.execute(CommandParser.get(in, this.context).pwReader(cr))) continue;
                    Util.println(Text.BYE[new Random().nextInt(4)], new Object[0]);
                    return;
                }
                catch (IOException ex) {
                    Util.errln(ex, new Object[0]);
                }
            }
            return;
        }
    }

    private void quit() throws IOException {
        if (this.out == System.out || this.out == System.err) {
            this.out.flush();
        } else {
            this.out.close();
        }
    }

    @Override
    protected final void parseArgs() throws IOException {
        this.ops = new IntList();
        this.vals = new StringList();
        MainParser arg = new MainParser(this);
        while (arg.more()) {
            char ch;
            String v;
            block9: {
                block7: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    v = null;
                                    if (!arg.dash()) break block7;
                                    ch = arg.next();
                                    if (ch != 'd') break block8;
                                    Prop.debug = true;
                                    break block9;
                                }
                                if ((!Strings.contains("t", ch) || !this.local()) && !Strings.contains("bcCiIoOqQrs", ch)) break block10;
                                v = arg.string();
                                break block9;
                            }
                            if ((!Strings.contains("Du", ch) || !this.local()) && !Strings.contains("RvVwWxXz", ch)) break block11;
                            v = "";
                            break block9;
                        }
                        if (this.local()) break block12;
                        switch (ch) {
                            case 'n': {
                                this.context.soptions.set(StaticOptions.HOST, arg.string());
                                break block9;
                            }
                            case 'p': {
                                this.context.soptions.set(StaticOptions.PORT, arg.number());
                                break block9;
                            }
                            case 'P': {
                                this.context.soptions.set(StaticOptions.PASSWORD, arg.string());
                                break block9;
                            }
                            case 'U': {
                                this.context.soptions.set(StaticOptions.USER, arg.string());
                                break block9;
                            }
                            default: {
                                throw arg.usage();
                            }
                        }
                    }
                    throw arg.usage();
                }
                v = arg.string().trim();
                char c = BaseX.isFile(v) ? (v.endsWith(".bxs") ? (char)'C' : 'Q') : (ch = 'q');
            }
            if (v == null) continue;
            this.ops.add((int)ch);
            this.vals.add(v);
        }
    }

    @Override
    public String header() {
        return Util.info(Text.S_CONSOLE_X, this.local() ? "Standalone" : "Client");
    }

    @Override
    public String usage() {
        return this.local() ? Text.S_LOCALINFO : Text.S_CLIENTINFO;
    }
}

