/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqError;
import org.basex.http.restxq.RestXqPath;
import org.basex.http.restxq.RestXqPerm;
import org.basex.http.web.WebFunction;
import org.basex.http.web.WebModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.http.MediaType;
import org.basex.util.http.Method;
import org.basex.util.http.Payload;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;

public final class RestXqFunction
extends WebFunction {
    private static final Pattern EQNAME = Pattern.compile("^Q\\{(.*?)}(.*)$");
    public final ArrayList<MediaType> produces = new ArrayList();
    final ArrayList<WebFunction.WebParam> queryParams = new ArrayList();
    final ArrayList<WebFunction.WebParam> formParams = new ArrayList();
    final Set<String> methods = new HashSet<String>();
    final TokenList allows = new TokenList();
    private final ArrayList<WebFunction.WebParam> errorParams = new ArrayList();
    private final ArrayList<WebFunction.WebParam> cookieParams = new ArrayList();
    private final ArrayList<MediaType> consumes = new ArrayList();
    public RestXqPath path;
    String singleton;
    private QNm requestBody;
    private RestXqError error;
    private RestXqPerm permission;

    public RestXqFunction(StaticFunc function, WebModule module, QueryContext qc) {
        super(function, module, qc);
    }

    @Override
    public boolean parseAnnotations(MainOptions mopts) throws QueryException, IOException {
        boolean[] declared = new boolean[this.function.arity()];
        boolean found = false;
        AnnList starts = AnnList.EMPTY;
        for (Ann ann : this.function.anns) {
            CsvParserOptions opts;
            Annotation def = ann.definition;
            if (def == null) continue;
            found |= Token.eq((byte[])def.name.uri(), (byte[][])new byte[][]{QueryText.REST_URI, QueryText.PERM_URI});
            Value value = ann.value();
            if (def == Annotation._REST_PATH) {
                try {
                    this.path = new RestXqPath(RestXqFunction.toString(value.itemAt(0L)), ann.info);
                    starts = starts.attach(ann);
                }
                catch (IllegalArgumentException ex) {
                    throw RestXqFunction.error(ann.info, ex.getMessage(), new Object[0]);
                }
                for (QNm name : this.path.varNames()) {
                    this.checkVariable(name, declared);
                }
                continue;
            }
            if (def == Annotation._REST_ERROR) {
                this.error(ann);
                if (starts.contains(def)) continue;
                starts = starts.attach(ann);
                continue;
            }
            if (def == Annotation._REST_CONSUMES) {
                RestXqFunction.strings(ann, this.consumes);
                continue;
            }
            if (def == Annotation._REST_PRODUCES) {
                RestXqFunction.strings(ann, this.produces);
                continue;
            }
            if (def == Annotation._REST_QUERY_PARAM) {
                this.queryParams.add(this.param(ann, declared));
                continue;
            }
            if (def == Annotation._REST_FORM_PARAM) {
                this.formParams.add(this.param(ann, declared));
                continue;
            }
            if (def == Annotation._REST_HEADER_PARAM) {
                this.headerParams.add(this.param(ann, declared));
                continue;
            }
            if (def == Annotation._REST_COOKIE_PARAM) {
                this.cookieParams.add(this.param(ann, declared));
                continue;
            }
            if (def == Annotation._REST_ERROR_PARAM) {
                this.errorParams.add(this.param(ann, declared));
                continue;
            }
            if (def == Annotation._REST_METHOD) {
                String mth = RestXqFunction.toString(value.itemAt(0L)).toUpperCase(Locale.ENGLISH);
                Item body = value.size() > 1L ? value.itemAt(1L) : null;
                this.addMethod(mth, body, declared, ann.info);
                continue;
            }
            if (def == Annotation._REST_SINGLE) {
                this.singleton = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", "\u0001"}, (String)(!value.isEmpty() ? RestXqFunction.toString(value.itemAt(0L)) : this.function.info.path() + ":" + this.function.info.line()));
                continue;
            }
            if (Token.eq((byte[])def.name.uri(), (byte[])QueryText.REST_URI)) {
                Item body = value.isEmpty() ? null : value.itemAt(0L);
                this.addMethod(Token.string((byte[])def.name.local()), body, declared, ann.info);
                continue;
            }
            if (Token.eq((byte[])def.name.uri(), (byte[])QueryText.OUTPUT_URI)) {
                String name = Token.string((byte[])def.name.local());
                String val = RestXqFunction.toString(value.itemAt(0L));
                try {
                    this.sopts.assign(name, val);
                    continue;
                }
                catch (BaseXException ex) {
                    throw RestXqFunction.error(ann.info, "%", new Object[]{ex});
                }
            }
            if (def == Annotation._PERM_ALLOW) {
                for (Item arg : value) {
                    this.allows.add(RestXqFunction.toString(arg));
                }
                continue;
            }
            if (def == Annotation._PERM_CHECK) {
                String p = value.isEmpty() ? "" : RestXqFunction.toString(value.itemAt(0L));
                QNm v = value.size() > 1L ? this.checkVariable(RestXqFunction.toString(value.itemAt(1L)), declared) : null;
                this.permission = new RestXqPerm(p, v);
                starts = starts.attach(ann);
                continue;
            }
            if (mopts == null) continue;
            if (def == Annotation._INPUT_CSV) {
                opts = new CsvParserOptions((CsvParserOptions)mopts.get(MainOptions.CSVPARSER));
                mopts.set(MainOptions.CSVPARSER, (Options)RestXqFunction.parse(opts, ann));
                continue;
            }
            if (def == Annotation._INPUT_JSON) {
                opts = new JsonParserOptions((JsonParserOptions)mopts.get(MainOptions.JSONPARSER));
                mopts.set(MainOptions.JSONPARSER, (Options)((JsonParserOptions)RestXqFunction.parse(opts, ann)));
                continue;
            }
            if (def != Annotation._INPUT_HTML) continue;
            opts = new HtmlOptions(mopts.get(MainOptions.HTMLPARSER));
            mopts.set(MainOptions.HTMLPARSER, (Options)((HtmlOptions)RestXqFunction.parse(opts, ann)));
        }
        for (MediaType produce : this.produces) {
            double d;
            String qs = produce.parameter("qs");
            if (qs == null || !((d = Token.toDouble((byte[])Token.token((String)qs))) < 0.0) && !(d > 1.0)) continue;
            throw this.error("Invalid quality factor: qs=%", qs);
        }
        return this.checkParsed(found, starts, declared);
    }

    Expr[] bind(Object ext, HTTPConnection conn, QueryContext qc, MainOptions mopts) throws QueryException, IOException {
        XQMap xQMap;
        Expr[] args = new Expr[this.function.arity()];
        if (this.path != null) {
            QNmMap<String> qnames = this.path.values(conn);
            for (QNm qname : qnames) {
                QNm qnm = new QNm(qname.string(), this.function.sc);
                if (this.function.sc.elemNS != null && Token.eq((byte[])qnm.uri(), (byte[])this.function.sc.elemNS)) {
                    qnm.uri(Token.EMPTY);
                }
                this.bind(qnm, args, (Value)Atm.get((String)((String)qnames.get(qname))), qc, "Path segment");
            }
        }
        if (this.requestBody != null) {
            Value value;
            MediaType type = conn.mediaType();
            byte[] body = conn.requestCtx.body().read();
            try {
                value = Payload.value((byte[])body, (MediaType)type, (MainOptions)mopts);
            }
            catch (IOException ex) {
                throw this.error("Body cannot be parsed as %: %.", type, ex);
            }
            this.bind(this.requestBody, args, value, qc, "Request body");
        }
        for (Object rxp : this.queryParams) {
            this.bind((WebFunction.WebParam)rxp, args, conn.requestCtx.queryValues().get((Item)Str.get((String)((WebFunction.WebParam)rxp).name())), qc);
        }
        for (Object rxp : this.formParams) {
            this.bind((WebFunction.WebParam)rxp, args, conn.requestCtx.formValues(mopts).get((Item)Str.get((String)((WebFunction.WebParam)rxp).name())), qc);
        }
        for (Object rxp : this.headerParams) {
            TokenList tl = new TokenList();
            for (String header : Collections.list(conn.request.getHeaders(((WebFunction.WebParam)rxp).name()))) {
                String[] stringArray = header.split(", *");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    tl.add(s);
                }
            }
            this.bind((WebFunction.WebParam)rxp, args, StrSeq.get((TokenList)tl), qc);
        }
        Cookie[] cookies = conn.request.getCookies();
        for (WebFunction.WebParam rxp : this.cookieParams) {
            Empty value = Empty.VALUE;
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!rxp.name().equals(c.getName())) continue;
                    value = Str.get((String)c.getValue());
                }
            }
            this.bind(rxp, args, (Value)value, qc);
        }
        if (ext instanceof QueryException) {
            QueryException qe = (QueryException)((Object)ext);
            xQMap = qe.map();
        } else {
            xQMap = XQMap.empty();
        }
        XQMap errors = xQMap;
        for (WebFunction.WebParam rxp : this.errorParams) {
            this.bind(rxp, args, errors.get((Item)Str.get((String)rxp.name())), qc);
        }
        if (ext instanceof RestXqFunction) {
            RestXqFunction rxf = (RestXqFunction)ext;
            if (this.permission.var != null) {
                this.bind(this.permission.var, args, (Value)RestXqPerm.map(rxf, conn), qc, "Error info");
            }
        }
        return args;
    }

    public boolean matches(HTTPConnection conn, QNm err, boolean perm) {
        if (!this.methods.isEmpty() && !this.methods.contains(conn.method) || !this.consumes(conn) || !this.produces(conn)) {
            return false;
        }
        if (perm) {
            return this.permission != null && this.permission.matches(conn);
        }
        if (err != null) {
            return this.error != null && this.error.matches(err);
        }
        return this.path != null && this.path.matches(conn);
    }

    public MediaType consumedType(MediaType type) {
        MediaType mt = null;
        for (MediaType consume : this.consumes) {
            if (!type.matches(consume) || mt != null && mt.compareTo(consume) <= 0) continue;
            mt = consume;
        }
        return mt == null ? MediaType.ALL_ALL : mt;
    }

    @Override
    public QueryException error(String msg, Object ... ext) {
        return RestXqFunction.error(this.function.info, msg, ext);
    }

    static QueryException error(InputInfo info, String msg, Object ... ext) {
        return QueryError.BASEX_RESTXQ_X.get(info, new Object[]{Util.info((Object)msg, (Object[])ext)});
    }

    @Override
    public int compareTo(WebFunction func) {
        if (!(func instanceof RestXqFunction)) {
            return -1;
        }
        RestXqFunction rxf = (RestXqFunction)func;
        if (this.path != null) {
            return this.path.compareTo(rxf.path);
        }
        if (this.error != null) {
            return this.error.compareTo(rxf.error);
        }
        return this.permission.compareTo(rxf.permission);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append(super.toString());
        if (!this.produces.isEmpty()) {
            sb.append(' ').append(this.produces);
        }
        return sb.toString();
    }

    private static <O extends Options> O parse(O options, Ann ann) throws QueryException, IOException {
        for (Item arg : ann.value()) {
            options.assign(Token.string((byte[])arg.string(ann.info)));
        }
        return options;
    }

    private void addMethod(String method, Item body, boolean[] declared, InputInfo info) throws QueryException {
        if (body != null) {
            Method m = Method.get((String)method);
            if (m != null && !m.body) {
                throw RestXqFunction.error(info, "Method % cannot have a body.", m);
            }
            if (this.requestBody != null) {
                throw RestXqFunction.error(info, "More than one body variable specified.", new Object[0]);
            }
            this.requestBody = this.checkVariable(RestXqFunction.toString(body), declared);
        }
        if (this.methods.contains(method)) {
            throw RestXqFunction.error(info, "Annotation %% is specified twice.", "%", method);
        }
        this.methods.add(method);
    }

    private boolean consumes(HTTPConnection conn) {
        MediaType mt = conn.mediaType();
        for (MediaType consume : this.consumes) {
            if (!mt.matches(consume)) continue;
            return true;
        }
        return this.consumes.isEmpty();
    }

    private boolean produces(HTTPConnection conn) {
        if (this.produces.isEmpty()) {
            return true;
        }
        for (MediaType accept : conn.accepts()) {
            for (MediaType produce : this.produces) {
                if (!produce.matches(accept)) continue;
                return true;
            }
        }
        return false;
    }

    private void bind(WebFunction.WebParam param, Expr[] args, Value value, QueryContext qc) throws QueryException {
        this.bind(param.var(), args, value.isEmpty() ? param.value() : value, qc, "Value of '" + param.name() + "'");
    }

    private static void strings(Ann ann, ArrayList<MediaType> list) {
        for (Item arg : ann.value()) {
            list.add(new MediaType(RestXqFunction.toString(arg)));
        }
    }

    private WebFunction.WebParam param(Ann ann, boolean ... declared) throws QueryException {
        Value value = ann.value();
        String name = RestXqFunction.toString(value.itemAt(0L));
        QNm var = this.checkVariable(RestXqFunction.toString(value.itemAt(1L)), declared);
        long al = value.size();
        ItemList items = new ItemList(al - 2L);
        int a = 2;
        while ((long)a < al) {
            items.add((Object)value.itemAt((long)a));
            ++a;
        }
        return new WebFunction.WebParam(var, name, items.value());
    }

    private void error(Ann ann) throws QueryException {
        if (this.error == null) {
            this.error = new RestXqError();
        }
        for (Item arg : ann.value()) {
            NameTest first;
            NamePart part;
            QNm name;
            String err = RestXqFunction.toString(arg);
            if (err.equals("*")) {
                name = null;
                part = null;
            } else if (err.startsWith("*:")) {
                byte[] local = Token.token((String)err.substring(2));
                if (!XMLToken.isNCName((byte[])local)) {
                    throw this.error("Invalid error code: %.", err);
                }
                name = new QNm(local);
                part = NamePart.LOCAL;
            } else if (err.endsWith(":*")) {
                byte[] prefix = Token.token((String)err.substring(0, err.length() - 2));
                if (!XMLToken.isNCName((byte[])prefix)) {
                    throw this.error("Invalid error code: %.", err);
                }
                name = new QNm(Token.concat((byte[][])new byte[][]{prefix, Token.cpToken((int)58)}), this.function.sc);
                part = NamePart.URI;
            } else {
                Matcher m = EQNAME.matcher(err);
                if (m.matches()) {
                    byte[] uri = Token.token((String)m.group(1));
                    byte[] local = Token.token((String)m.group(2));
                    if (local.length == 1 && local[0] == 42) {
                        name = new QNm(Token.cpToken((int)58), uri);
                        part = NamePart.URI;
                    } else {
                        if (!XMLToken.isNCName((byte[])local) || !Uri.get((byte[])uri).isValid()) {
                            throw this.error("Invalid error code: %.", err);
                        }
                        name = new QNm(local, uri);
                        part = NamePart.FULL;
                    }
                } else {
                    byte[] nm = Token.token((String)err);
                    if (!XMLToken.isQName((byte[])nm)) {
                        throw this.error("Invalid error code: %.", err);
                    }
                    name = new QNm(nm, this.function.sc);
                    part = NamePart.FULL;
                }
            }
            if (name != null && name.hasPrefix() && !name.hasURI()) {
                throw this.error("No namespace declared for '%'.", name);
            }
            NameTest test = part != null ? new NameTest(name, part, NodeType.ELEMENT, null) : null;
            Function<NameTest, String> toString = t -> t != null ? t.toString() : "*";
            if (!this.error.isEmpty() && ((first = this.error.get(0)) != null ? first.part() != part : part != null)) {
                throw this.error("Errors must be of the same precedence (\"%\" vs \"%\").", toString.apply(first), toString.apply(test));
            }
            if (this.error.add(test)) continue;
            throw this.error("The same error has been specified twice: \"%\".", toString.apply(test));
        }
    }
}

