/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Dir;
import org.basex.core.cmd.List;
import org.basex.core.cmd.XQuery;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPException;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.index.resource.ResourceType;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.Function;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;

final class RESTRetrieve
extends RESTCmd {
    private RESTRetrieve(RESTSession session) {
        super(session);
    }

    @Override
    protected void run0() throws IOException {
        boolean contents;
        for (Command cmd : this.session) {
            this.run(cmd);
        }
        HTTPConnection conn = this.session.conn;
        SerializerOptions sopts = conn.sopts();
        ServletOutputStream os = conn.response.getOutputStream();
        String database = conn.db();
        String path = conn.dbpath();
        boolean db = database.isEmpty();
        boolean bl = contents = !db && this.run(Function._DB_EXISTS).equals("false");
        if (db || contents) {
            List cmd;
            FBuilder root;
            if (db) {
                root = FElem.build((QNm)RESTText.Q_DATABASES).declareNS();
                cmd = new List();
            } else {
                root = FElem.build((QNm)RESTText.Q_DATABASE).declareNS().add(RESTText.Q_NAME, (Object)database);
                cmd = new Dir(path);
            }
            Table table = new Table(this.run((Command)cmd));
            for (TokenList list : table.contents) {
                boolean dir;
                boolean bl2 = dir = !db && Token.eq((byte[])RESTText.Q_DIR.string(), (byte[])((byte[])list.get(1)));
                FBuilder elem = FElem.build((QNm)(db ? RESTText.Q_DATABASE : (dir ? RESTText.Q_DIR : RESTText.Q_RESOURCE)));
                if (!dir) {
                    int ll = list.size() - (db ? 1 : 0);
                    for (int l = 1; l < ll; ++l) {
                        elem.add(new QNm(Token.lc((byte[])((byte[])table.header.get(l)))), (byte[])list.get(l));
                    }
                }
                root.add(elem.add((byte[])list.get(0)));
            }
            conn.initResponse();
            try (Serializer ser = Serializer.get((OutputStream)os, (SerializerOptions)sopts);){
                ser.serialize((Item)root.finish());
            }
        } else {
            Function function;
            ResourceType type = ResourceType.valueOf((String)this.run(Function._DB_TYPE).toUpperCase(Locale.ENGLISH));
            if (type == ResourceType.XML) {
                function = Function._DB_GET;
            } else {
                sopts.set(SerializerOptions.MEDIA_TYPE, this.run(Function._DB_CONTENT_TYPE));
                this.context.options.set(MainOptions.SERIALIZER, (Options)sopts);
                function = type == ResourceType.BINARY ? Function._DB_GET_BINARY : Function._DB_GET_VALUE;
            }
            conn.initResponse();
            this.run((Command)this.query(function), (OutputStream)os);
        }
    }

    private String run(Function function) throws HTTPException {
        return this.run((Command)this.query(function));
    }

    private XQuery query(Function function) {
        HTTPConnection conn = this.session.conn;
        String query = "declare variable $db external;declare variable $path external;" + function.args(new Object[]{" $db", " $path"});
        return new XQuery(query).bind("db", (Object)conn.db()).bind("path", (Object)conn.dbpath());
    }

    static RESTRetrieve get(RESTSession session) {
        return new RESTRetrieve(session);
    }
}

