/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.Context;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPStatus;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommands;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.NewlineInput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.list.StringList;

final class RESTPost {
    private RESTPost() {
    }

    public static RESTCmd get(RESTSession session) throws IOException {
        DBNode doc;
        HTTPConnection conn = session.conn;
        String encoding = conn.request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try (NewlineInput ni = new NewlineInput((InputStream)conn.request.getInputStream());){
            doc = new DBNode((IO)new IOContent(ni.encoding(encoding).content()));
        }
        catch (IOException ex) {
            throw HTTPStatus.BAD_REQUEST_X.get(ex);
        }
        try {
            String value;
            String name;
            Context ctx = conn.context;
            String cmd = RESTPost.value("local-name(*)", (Item)doc, ctx);
            if (cmd.equals("commands")) {
                String script = DataBuilder.stripNamespace((ANode)doc, (byte[])RESTText.REST_URI, (Context)ctx).serialize().toString();
                return RESTCommands.get(session, script, false);
            }
            SerializerOptions sopts = conn.sopts();
            try (QueryProcessor qp = new QueryProcessor("*/*:parameter", ctx).context((Object)doc);){
                for (Item param : qp.value()) {
                    name = RESTPost.value("@name", param, ctx);
                    value = RESTPost.value("@value", param, ctx);
                    if (sopts.option(name) != null) {
                        sopts.assign(name, value);
                        continue;
                    }
                    throw HTTPStatus.UNKNOWN_PARAM_X.get(name);
                }
            }
            qp = new QueryProcessor("*/*:option", ctx).context((Object)doc);
            try {
                for (Object item : qp.value()) {
                    name = RESTPost.value("@name", (Item)item, ctx).toUpperCase(Locale.ENGLISH);
                    value = RESTPost.value("@value", (Item)item, ctx);
                    ctx.options.assign(name, value);
                }
            }
            finally {
                if (qp != null) {
                    qp.close();
                }
            }
            HashMap<String, Map.Entry<Object, String>> bindings = new HashMap<String, Map.Entry<Object, String>>();
            try (QueryProcessor qp = new QueryProcessor("*/*:variable", ctx).context((Object)doc);){
                for (Item item : qp.value()) {
                    String name2 = RESTPost.value("@name", item, ctx);
                    String value2 = RESTPost.value("@value", item, ctx);
                    String type = RESTPost.value("@type", item, ctx);
                    bindings.compute(name2, (k, v) -> {
                        StringList list = new StringList();
                        if (v != null) {
                            Object patt3150$temp = v.getKey();
                            if (patt3150$temp instanceof String[]) {
                                String[] strings;
                                for (String string : strings = (String[])patt3150$temp) {
                                    list.add((Object)string);
                                }
                            } else if (v.getKey() instanceof String) {
                                list.add(k);
                            }
                        }
                        return new AbstractMap.SimpleEntry<Object[], String>(((StringList)list.add((Object)value2)).finish(), type);
                    });
                }
            }
            String value3 = null;
            try (QueryProcessor qp = new QueryProcessor("*/*:context/(*|text()[normalize-space()])", ctx).context((Object)doc);){
                for (Item item : qp.value()) {
                    if (value3 != null) {
                        throw HTTPStatus.MULTIPLE_CONTEXTS.get(new Object[0]);
                    }
                    value3 = DataBuilder.stripNamespace((ANode)((ANode)item), (byte[])RESTText.REST_URI, (Context)ctx).serialize().toString();
                }
            }
            if (value3 != null) {
                bindings.put(null, new AbstractMap.SimpleEntry<Object, String>(value3, NodeType.DOCUMENT_NODE.toString()));
            }
            String text = RESTPost.value("*/*:text/text()", (Item)doc, ctx);
            return switch (cmd) {
                case "command" -> RESTCommands.get(session, text, true);
                case "run" -> RESTRun.get(session, text, bindings);
                case "query" -> RESTQuery.get(session, text, bindings);
                default -> throw HTTPStatus.BAD_REQUEST_X.get("Invalid POST command: " + cmd);
            };
        }
        catch (QueryException ex) {
            throw HTTPStatus.BAD_REQUEST_X.get(new Object[]{ex});
        }
    }

    private static String value(String query, Item value, Context ctx) throws QueryException {
        try (QueryProcessor qp = new QueryProcessor(query, ctx).context((Object)value);){
            Item item = qp.iter().next();
            String string = item == null ? "" : Token.string((byte[])item.string(null));
            return string;
        }
    }
}

