/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.toolkit;

import java.lang.ref.SoftReference;
import net.xqj.core.TextContainer;
import net.xqj.core.util.StringWriter;

public class ReoFactory {
    private static final ThreadLocal<SoftReference<ReoFactory>> threadLocal = new ThreadLocal();
    private char[] _smallCharBuffer = null;
    private char[] _mediumCharBuffer = null;
    private byte[] _smallByteBuffer = null;
    private byte[] _mediumByteBuffer = null;
    private TextContainer textContainer = null;
    private StringWriter stringWriter = null;

    public static ReoFactory getInstance() {
        SoftReference<ReoFactory> softReference = threadLocal.get();
        ReoFactory factory = null;
        if (softReference == null) {
            factory = new ReoFactory();
            threadLocal.set(new SoftReference<ReoFactory>(factory));
        } else {
            factory = softReference.get();
            if (factory == null) {
                factory = new ReoFactory();
                threadLocal.set(new SoftReference<ReoFactory>(factory));
            }
        }
        return factory;
    }

    public char[] getSmallCBuffer(int minSize) {
        char[] result = null;
        if (this._smallCharBuffer != null && this._smallCharBuffer.length >= minSize) {
            result = this._smallCharBuffer;
            this._smallCharBuffer = null;
        } else {
            result = new char[minSize];
        }
        return result;
    }

    public void returnSmallCBuffer(char[] buffer) {
        this._smallCharBuffer = buffer;
    }

    public char[] getMediumCBuffer(int minSize) {
        char[] result = null;
        if (this._mediumCharBuffer != null && this._mediumCharBuffer.length >= minSize) {
            result = this._mediumCharBuffer;
            this._mediumCharBuffer = null;
        } else {
            result = new char[minSize];
        }
        return result;
    }

    public void returnMediumCBuffer(char[] buffer) {
        this._mediumCharBuffer = buffer;
    }

    public byte[] getSmallBuffer(int minSize) {
        byte[] result = null;
        if (this._smallByteBuffer != null && this._smallByteBuffer.length >= minSize) {
            result = this._smallByteBuffer;
            this._smallByteBuffer = null;
        } else {
            result = new byte[minSize];
        }
        return result;
    }

    public void returnSmallBuffer(byte[] buffer) {
        this._smallByteBuffer = buffer;
    }

    public byte[] getMediumBuffer(int minSize) {
        byte[] result = null;
        if (this._mediumByteBuffer != null && this._mediumByteBuffer.length >= minSize) {
            result = this._mediumByteBuffer;
            this._mediumCharBuffer = null;
        } else {
            result = new byte[minSize];
        }
        return result;
    }

    public void returnMediumBuffer(byte[] buffer) {
        this._mediumByteBuffer = buffer;
    }

    public TextContainer getTextContainer() {
        return this.textContainer != null ? this.textContainer : new TextContainer();
    }

    public TextContainer getTextContainer(char[] buffer) {
        TextContainer retValue = null;
        if (this.textContainer != null) {
            this.textContainer.setRawCharArray(buffer);
            retValue = this.textContainer;
            this.textContainer = null;
        } else {
            retValue = new TextContainer(buffer);
        }
        return retValue;
    }

    public void returnTextContainer(TextContainer textContainer) {
        textContainer.reset();
        this.textContainer = textContainer;
    }

    public StringWriter getStringWriter() {
        return this.stringWriter != null ? this.stringWriter : new StringWriter();
    }

    public StringWriter getStringWriter(TextContainer textContainer) {
        StringWriter retValue = null;
        if (this.stringWriter != null) {
            this.stringWriter.setTextContainer(textContainer);
            retValue = this.stringWriter;
            this.stringWriter = null;
        } else {
            retValue = new StringWriter(textContainer);
        }
        return retValue;
    }

    public void returnStringWriter(StringWriter stringWriter) {
        stringWriter.reset();
        this.stringWriter = stringWriter;
    }
}

