/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.pool;

import com.xqj2.XQConnection2;
import java.util.HashSet;
import javax.xml.xquery.PooledXQConnection;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConnectionEvent;
import javax.xml.xquery.XQConnectionEventListener;
import javax.xml.xquery.XQException;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.pool.XQConnectionProxy;

public class GenericPooledXQConnection
implements PooledXQConnection {
    protected final GenericXQConnection hardConnection;
    protected HashSet<XQConnectionEventListener> listeners = new HashSet();
    protected XQConnection2 connectionProxy;

    public GenericPooledXQConnection(GenericXQConnection hardConnection) {
        this.hardConnection = hardConnection;
    }

    public XQConnection getConnection() throws XQException {
        if (this.connectionProxy != null) {
            if (!this.connectionProxy.isClosed()) {
                this.connectionProxy.close();
            }
            this.connectionProxy = null;
        }
        if (this.connectionProxy == null) {
            this.connectionProxy = new XQConnectionProxy(this.hardConnection, this);
        }
        return this.connectionProxy;
    }

    public synchronized void notifyConnectionClosed() {
        this.connectionProxy = null;
        for (XQConnectionEventListener listener : this.listeners) {
            listener.connectionClosed(new XQConnectionEvent((PooledXQConnection)this));
        }
    }

    public synchronized void notifyConnectionErrorOccurred(XQException exception) {
        this.connectionProxy = null;
        for (XQConnectionEventListener listener : this.listeners) {
            listener.connectionErrorOccurred(new XQConnectionEvent((PooledXQConnection)this, exception));
        }
    }

    public void close() throws XQException {
        this.hardConnection.close();
    }

    public void addConnectionEventListener(XQConnectionEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeConnectionEventListener(XQConnectionEventListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

