# asdf [![Lint](https://github.com/asdf-vm/asdf/actions/workflows/lint.yml/badge.svg)](https://github.com/asdf-vm/asdf/actions/workflows/lint.yml) [![Tests](https://github.com/asdf-vm/asdf/actions/workflows/tests.yml/badge.svg)](https://github.com/asdf-vm/asdf/actions/workflows/tests.yml)

**Manage multiple runtime versions with a single CLI tool, extendable via plugins** - [docs at asdf-vm.com](https://asdf-vm.com/)

asdf is a CLI tool that can manage multiple language runtime versions on a per-project basis. It is like `gvm`, `nvm`, `rbenv` & `pyenv` (and more) all in one! Simply install your language's plugin!

## Why use asdf?

- single CLI for multiple languages
- consistent commands to manage all your languages
- single global config keeping defaults in one place
- single `.tool-versions` config file per project
- support for existing config files `.node-version`, `.nvmrc`, `.ruby-version` for easy migration
- automatically switches runtime versions as you traverse your directories
- simple plugin system to add support for your language of choice
- shell completion available for common shells (Bash, Zsh, Fish, Elvish)

## Documentation

[Please head over to the documentation site for more information](https://asdf-vm.com/)!

- [Getting Started](https://asdf-vm.com/guide/getting-started.html)
- [All Commands](https://asdf-vm.com/manage/commands.html)
- [All Plugins](https://github.com/asdf-vm/asdf-plugins)
- [Create a Plugin](https://asdf-vm.com/plugins/create.html) with our [asdf-plugin-template](https://github.com/asdf-vm/asdf-plugin-template)
- [asdf GitHub Actions](https://github.com/asdf-vm/actions)

## Contributing

See [CONTRIBUTING.md in the repo](https://github.com/asdf-vm/asdf/blob/master/CONTRIBUTING.md) or the [Contributing section on the docs site](http://asdf-vm.com/contribute/core.html#initial-setup).

## Community & Questions

- [FAQ](https://asdf-vm.com/more/faq.html)
- [![GitHub Issues](https://icongr.am/simple/github.svg?color=808080&size=16) GitHub Issues](https://github.com/asdf-vm/asdf/issues): report a bug or raise a feature request to the `asdf` core team
- [![StackOverflow Tag](https://icongr.am/fontawesome/stack-overflow.svg?size=16&color=808080) StackOverflow Tag](https://stackoverflow.com/questions/tagged/asdf-vm): see existing Q&A for `asdf`. Some of the core team watch this tag in addition to our helpful community

## Ballad of asdf

> Once upon a time there was a programming language<br/>
> There were many versions of it<br/>
> So people wrote a version manager for it<br/>
> To switch between versions for projects<br/>
> Different, old, new.
> 
> Then there came more programming languages<br/>
> So there came more version managers<br/>
> And many commands for them
> 
> I installed a lot of them<br/>
> I learnt a lot of commands
> 
> Then I said, just one more version manager<br/>
> Which I will write instead
> 
> So, there came another version manager<br/>
> **asdf version manager** - <https://github.com/asdf-vm/asdf>
> 
> A version manager so extendable<br/>
> for which anyone can create a plugin<br/>
> To support their favourite language<br/>
> No more installing more version managers<br/>
> Or learning more commands

---

<figure>
  <blockquote>
  This was the mail I wrote to a few friends to tell them about the project. Thanks to <a href="https://twitter.com/roshanvid" target="_blank" rel="noreferrer">@roshanvid</a> for suggesting that this go into the readme
  </blockquote>
  <figcaption>
    <a href="https://github.com/HashNuke" target="_blank" rel="noreferrer">@HashNuke</a>
  </figcaption>
</figure>
