/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.BatchStartAware;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.FatalExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SequenceReportingEventHandler;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.TimeoutHandler;
import java.util.concurrent.atomic.AtomicInteger;

public final class BatchEventProcessor<T>
implements EventProcessor {
    private static final int IDLE = 0;
    private static final int HALTED = 1;
    private static final int RUNNING = 2;
    private final AtomicInteger running = new AtomicInteger(0);
    private ExceptionHandler<? super T> exceptionHandler = new FatalExceptionHandler();
    private final DataProvider<T> dataProvider;
    private final SequenceBarrier sequenceBarrier;
    private final EventHandler<? super T> eventHandler;
    private final Sequence sequence = new Sequence(-1L);
    private final TimeoutHandler timeoutHandler;
    private final BatchStartAware batchStartAware;

    public BatchEventProcessor(DataProvider<T> dataProvider, SequenceBarrier sequenceBarrier, EventHandler<? super T> eventHandler) {
        this.dataProvider = dataProvider;
        this.sequenceBarrier = sequenceBarrier;
        this.eventHandler = eventHandler;
        if (eventHandler instanceof SequenceReportingEventHandler) {
            ((SequenceReportingEventHandler)eventHandler).setSequenceCallback(this.sequence);
        }
        this.batchStartAware = eventHandler instanceof BatchStartAware ? (BatchStartAware)((Object)eventHandler) : null;
        this.timeoutHandler = eventHandler instanceof TimeoutHandler ? (TimeoutHandler)((Object)eventHandler) : null;
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void halt() {
        this.running.set(1);
        this.sequenceBarrier.alert();
    }

    @Override
    public boolean isRunning() {
        return this.running.get() != 0;
    }

    public void setExceptionHandler(ExceptionHandler<? super T> exceptionHandler) {
        if (null == exceptionHandler) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.running.compareAndSet(0, 2)) {
            this.sequenceBarrier.clearAlert();
            this.notifyStart();
            try {
                if (this.running.get() != 2) return;
                this.processEvents();
                return;
            }
            finally {
                this.notifyShutdown();
                this.running.set(0);
            }
        } else {
            if (this.running.get() == 2) {
                throw new IllegalStateException("Thread is already running");
            }
            this.earlyExit();
        }
    }

    private void processEvents() {
        Object event = null;
        long nextSequence = this.sequence.get() + 1L;
        while (true) {
            try {
                while (true) {
                    long availableSequence = this.sequenceBarrier.waitFor(nextSequence);
                    if (this.batchStartAware != null) {
                        this.batchStartAware.onBatchStart(availableSequence - nextSequence + 1L);
                    }
                    while (nextSequence <= availableSequence) {
                        event = this.dataProvider.get(nextSequence);
                        this.eventHandler.onEvent(event, nextSequence, nextSequence == availableSequence);
                        ++nextSequence;
                    }
                    this.sequence.set(availableSequence);
                }
            }
            catch (TimeoutException e) {
                this.notifyTimeout(this.sequence.get());
                continue;
            }
            catch (AlertException ex) {
                if (this.running.get() == 2) continue;
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleEventException(ex, nextSequence, event);
                this.sequence.set(nextSequence);
                ++nextSequence;
                continue;
            }
            break;
        }
    }

    private void earlyExit() {
        this.notifyStart();
        this.notifyShutdown();
    }

    private void notifyTimeout(long availableSequence) {
        try {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.onTimeout(availableSequence);
            }
        }
        catch (Throwable e) {
            this.exceptionHandler.handleEventException(e, availableSequence, null);
        }
    }

    private void notifyStart() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.eventHandler)).onStart();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnStartException(ex);
            }
        }
    }

    private void notifyShutdown() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.eventHandler)).onShutdown();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnShutdownException(ex);
            }
        }
    }
}

