/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.carrot2.text.preprocessing.filter.CompleteLabelFilterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RightCompleteLabelFilter
extends CompleteLabelFilterBase {
    RightCompleteLabelFilter() {
    }

    @Override
    int[] createLcp(List<CompleteLabelFilterBase.LabelIndexWithCodes> phraseCodes) {
        int[] lcpArray = new int[phraseCodes.size()];
        for (int i = 0; i < phraseCodes.size() - 1; ++i) {
            int[] codes = phraseCodes.get(i).getCodes();
            int[] nextCodes = phraseCodes.get(i + 1).getCodes();
            int minLength = Math.min(codes.length, nextCodes.length);
            for (int j = 0; j < minLength && codes[j] == nextCodes[j]; ++j) {
                int n = i;
                lcpArray[n] = lcpArray[n] + 1;
            }
        }
        lcpArray[lcpArray.length - 1] = -1;
        return lcpArray;
    }

    @Override
    List<CompleteLabelFilterBase.LabelIndexWithCodes> sortPhraseCodes(List<CompleteLabelFilterBase.LabelIndexWithCodes> phrasesWithCodes) {
        ArrayList sortedPhraseCodes = Lists.newArrayList(phrasesWithCodes);
        Collections.sort(sortedPhraseCodes, new Comparator<CompleteLabelFilterBase.LabelIndexWithCodes>(){

            @Override
            public int compare(CompleteLabelFilterBase.LabelIndexWithCodes o1, CompleteLabelFilterBase.LabelIndexWithCodes o2) {
                int[] codesA = o1.getCodes();
                int[] codesB = o2.getCodes();
                int minLength = Math.min(codesA.length, codesB.length);
                for (int i = 0; i < minLength; ++i) {
                    if (codesA[i] < codesB[i]) {
                        return -1;
                    }
                    if (codesA[i] <= codesB[i]) continue;
                    return 1;
                }
                if (codesA.length < codesB.length) {
                    return -1;
                }
                if (codesA.length > codesB.length) {
                    return 1;
                }
                return 0;
            }
        });
        return sortedPhraseCodes;
    }
}

