/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SparseColumnMatrix
extends AbstractMatrix {
    private int[] cardinality;
    private Vector[] columns;

    public SparseColumnMatrix() {
    }

    public SparseColumnMatrix(int[] cardinality, RandomAccessSparseVector[] columns) {
        this.cardinality = (int[])cardinality.clone();
        this.columns = (Vector[])columns.clone();
        for (int col = 0; col < cardinality[1]; ++col) {
            this.columns[col] = columns[col].clone();
        }
    }

    public SparseColumnMatrix(int[] cardinality) {
        this.cardinality = (int[])cardinality.clone();
        this.columns = new RandomAccessSparseVector[cardinality[1]];
        for (int col = 0; col < cardinality[1]; ++col) {
            this.columns[col] = new RandomAccessSparseVector(cardinality[0]);
        }
    }

    public int[] size() {
        return this.cardinality;
    }

    public Matrix clone() {
        SparseColumnMatrix clone = (SparseColumnMatrix)super.clone();
        clone.cardinality = (int[])this.cardinality.clone();
        clone.columns = new Vector[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            clone.columns[i] = this.columns[i].clone();
        }
        return clone;
    }

    protected Vector slice(int index) {
        return this.getColumn(index);
    }

    public int numSlices() {
        return this.numCols();
    }

    public double getQuick(int row, int column) {
        if (this.columns[column] == null) {
            return 0.0;
        }
        return this.columns[column].getQuick(row);
    }

    public Matrix like() {
        return new SparseColumnMatrix(this.cardinality);
    }

    public Matrix like(int rows, int columns) {
        int[] c = new int[]{rows, columns};
        return new SparseColumnMatrix(c);
    }

    public void setQuick(int row, int column, double value) {
        if (this.columns[column] == null) {
            this.columns[column] = new RandomAccessSparseVector(this.cardinality[0]);
        }
        this.columns[column].setQuick(row, value);
    }

    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[1] = this.columns.length;
        for (int col = 0; col < this.cardinality[1]; ++col) {
            result[0] = Math.max(result[0], this.columns[col].getNumNondefaultElements());
        }
        return result;
    }

    public Matrix viewPart(int[] offset, int[] size) {
        if (size[1] > this.columns.length || size[0] > this.columns[1].size()) {
            throw new CardinalityException();
        }
        if (offset[1] < 0 || offset[1] + size[1] > this.columns.length || offset[0] < 0 || offset[0] + size[0] > this.columns[1].size()) {
            throw new IndexException();
        }
        return new MatrixView(this, offset, size);
    }

    public Matrix assignColumn(int column, Vector other) {
        if (other.size() != this.cardinality[0] || column >= this.cardinality[1]) {
            throw new CardinalityException();
        }
        this.columns[column].assign(other);
        return this;
    }

    public Matrix assignRow(int row, Vector other) {
        if (row >= this.cardinality[0] || other.size() != this.cardinality[1]) {
            throw new CardinalityException();
        }
        for (int col = 0; col < this.cardinality[1]; ++col) {
            this.columns[col].setQuick(row, other.getQuick(col));
        }
        return this;
    }

    public Vector getColumn(int column) {
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException();
        }
        return this.columns[column];
    }

    public Vector getRow(int row) {
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException();
        }
        return new AbstractMatrix.TransposeViewVector(this, row, false);
    }
}

