#ifndef __ASM_UNISTD_PORTABLE_H
#define __ASM_UNISTD_PORTABLE_H

/* Derived from android-14/arch-arm/usr/include/asm/unistd.h */

#define __NR_SYSCALL_BASE_portable 0

#define __NR_restart_syscall_portable (__NR_SYSCALL_BASE_portable+ 0)
#define __NR_exit_portable (__NR_SYSCALL_BASE_portable+ 1)
#define __NR_fork_portable (__NR_SYSCALL_BASE_portable+ 2)
#define __NR_read_portable (__NR_SYSCALL_BASE_portable+ 3)
#define __NR_write_portable (__NR_SYSCALL_BASE_portable+ 4)
#define __NR_open_portable (__NR_SYSCALL_BASE_portable+ 5)
#define __NR_close_portable (__NR_SYSCALL_BASE_portable+ 6)

#define __NR_creat_portable (__NR_SYSCALL_BASE_portable+ 8)
#define __NR_link_portable (__NR_SYSCALL_BASE_portable+ 9)
#define __NR_unlink_portable (__NR_SYSCALL_BASE_portable+ 10)
#define __NR_execve_portable (__NR_SYSCALL_BASE_portable+ 11)
#define __NR_chdir_portable (__NR_SYSCALL_BASE_portable+ 12)
#define __NR_time_portable (__NR_SYSCALL_BASE_portable+ 13)
#define __NR_mknod_portable (__NR_SYSCALL_BASE_portable+ 14)
#define __NR_chmod_portable (__NR_SYSCALL_BASE_portable+ 15)
#define __NR_lchown_portable (__NR_SYSCALL_BASE_portable+ 16)

#define __NR_lseek_portable (__NR_SYSCALL_BASE_portable+ 19)
#define __NR_getpid_portable (__NR_SYSCALL_BASE_portable+ 20)
#define __NR_mount_portable (__NR_SYSCALL_BASE_portable+ 21)
#define __NR_umount_portable (__NR_SYSCALL_BASE_portable+ 22)
#define __NR_setuid_portable (__NR_SYSCALL_BASE_portable+ 23)
#define __NR_getuid_portable (__NR_SYSCALL_BASE_portable+ 24)
#define __NR_stime_portable (__NR_SYSCALL_BASE_portable+ 25)
#define __NR_ptrace_portable (__NR_SYSCALL_BASE_portable+ 26)
#define __NR_alarm_portable (__NR_SYSCALL_BASE_portable+ 27)

#define __NR_pause_portable (__NR_SYSCALL_BASE_portable+ 29)
#define __NR_utime_portable (__NR_SYSCALL_BASE_portable+ 30)

#define __NR_access_portable (__NR_SYSCALL_BASE_portable+ 33)
#define __NR_nice_portable (__NR_SYSCALL_BASE_portable+ 34)

#define __NR_sync_portable (__NR_SYSCALL_BASE_portable+ 36)
#define __NR_kill_portable (__NR_SYSCALL_BASE_portable+ 37)
#define __NR_rename_portable (__NR_SYSCALL_BASE_portable+ 38)
#define __NR_mkdir_portable (__NR_SYSCALL_BASE_portable+ 39)
#define __NR_rmdir_portable (__NR_SYSCALL_BASE_portable+ 40)
#define __NR_dup_portable (__NR_SYSCALL_BASE_portable+ 41)
#define __NR_pipe_portable (__NR_SYSCALL_BASE_portable+ 42)
#define __NR_times_portable (__NR_SYSCALL_BASE_portable+ 43)

#define __NR_brk_portable (__NR_SYSCALL_BASE_portable+ 45)
#define __NR_setgid_portable (__NR_SYSCALL_BASE_portable+ 46)
#define __NR_getgid_portable (__NR_SYSCALL_BASE_portable+ 47)

#define __NR_geteuid_portable (__NR_SYSCALL_BASE_portable+ 49)
#define __NR_getegid_portable (__NR_SYSCALL_BASE_portable+ 50)
#define __NR_acct_portable (__NR_SYSCALL_BASE_portable+ 51)
#define __NR_umount2_portable (__NR_SYSCALL_BASE_portable+ 52)

#define __NR_ioctl_portable (__NR_SYSCALL_BASE_portable+ 54)
#define __NR_fcntl_portable (__NR_SYSCALL_BASE_portable+ 55)

#define __NR_setpgid_portable (__NR_SYSCALL_BASE_portable+ 57)

#define __NR_umask_portable (__NR_SYSCALL_BASE_portable+ 60)
#define __NR_chroot_portable (__NR_SYSCALL_BASE_portable+ 61)
#define __NR_ustat_portable (__NR_SYSCALL_BASE_portable+ 62)
#define __NR_dup2_portable (__NR_SYSCALL_BASE_portable+ 63)
#define __NR_getppid_portable (__NR_SYSCALL_BASE_portable+ 64)
#define __NR_getpgrp_portable (__NR_SYSCALL_BASE_portable+ 65)
#define __NR_setsid_portable (__NR_SYSCALL_BASE_portable+ 66)
#define __NR_sigaction_portable (__NR_SYSCALL_BASE_portable+ 67)

#define __NR_setreuid_portable (__NR_SYSCALL_BASE_portable+ 70)
#define __NR_setregid_portable (__NR_SYSCALL_BASE_portable+ 71)
#define __NR_sigsuspend_portable (__NR_SYSCALL_BASE_portable+ 72)
#define __NR_sigpending_portable (__NR_SYSCALL_BASE_portable+ 73)
#define __NR_sethostname_portable (__NR_SYSCALL_BASE_portable+ 74)
#define __NR_setrlimit_portable (__NR_SYSCALL_BASE_portable+ 75)
#define __NR_getrlimit_portable (__NR_SYSCALL_BASE_portable+ 76)
#define __NR_getrusage_portable (__NR_SYSCALL_BASE_portable+ 77)
#define __NR_gettimeofday_portable (__NR_SYSCALL_BASE_portable+ 78)
#define __NR_settimeofday_portable (__NR_SYSCALL_BASE_portable+ 79)
#define __NR_getgroups_portable (__NR_SYSCALL_BASE_portable+ 80)
#define __NR_setgroups_portable (__NR_SYSCALL_BASE_portable+ 81)
#define __NR_select_portable (__NR_SYSCALL_BASE_portable+ 82)
#define __NR_symlink_portable (__NR_SYSCALL_BASE_portable+ 83)

#define __NR_readlink_portable (__NR_SYSCALL_BASE_portable+ 85)
#define __NR_uselib_portable (__NR_SYSCALL_BASE_portable+ 86)
#define __NR_swapon_portable (__NR_SYSCALL_BASE_portable+ 87)
#define __NR_reboot_portable (__NR_SYSCALL_BASE_portable+ 88)
#define __NR_readdir_portable (__NR_SYSCALL_BASE_portable+ 89)
#define __NR_mmap_portable (__NR_SYSCALL_BASE_portable+ 90)
#define __NR_munmap_portable (__NR_SYSCALL_BASE_portable+ 91)
#define __NR_truncate_portable (__NR_SYSCALL_BASE_portable+ 92)
#define __NR_ftruncate_portable (__NR_SYSCALL_BASE_portable+ 93)
#define __NR_fchmod_portable (__NR_SYSCALL_BASE_portable+ 94)
#define __NR_fchown_portable (__NR_SYSCALL_BASE_portable+ 95)
#define __NR_getpriority_portable (__NR_SYSCALL_BASE_portable+ 96)
#define __NR_setpriority_portable (__NR_SYSCALL_BASE_portable+ 97)

#define __NR_statfs_portable (__NR_SYSCALL_BASE_portable+ 99)
#define __NR_fstatfs_portable (__NR_SYSCALL_BASE_portable+100)

#define __NR_socketcall_portable (__NR_SYSCALL_BASE_portable+102)
#define __NR_syslog_portable (__NR_SYSCALL_BASE_portable+103)
#define __NR_setitimer_portable (__NR_SYSCALL_BASE_portable+104)
#define __NR_getitimer_portable (__NR_SYSCALL_BASE_portable+105)
#define __NR_stat_portable (__NR_SYSCALL_BASE_portable+106)
#define __NR_lstat_portable (__NR_SYSCALL_BASE_portable+107)
#define __NR_fstat_portable (__NR_SYSCALL_BASE_portable+108)

#define __NR_vhangup_portable (__NR_SYSCALL_BASE_portable+111)

#define __NR_syscall_portable (__NR_SYSCALL_BASE_portable+113)
#define __NR_wait4_portable (__NR_SYSCALL_BASE_portable+114)
#define __NR_swapoff_portable (__NR_SYSCALL_BASE_portable+115)
#define __NR_sysinfo_portable (__NR_SYSCALL_BASE_portable+116)
#define __NR_ipc_portable (__NR_SYSCALL_BASE_portable+117)
#define __NR_fsync_portable (__NR_SYSCALL_BASE_portable+118)
#define __NR_sigreturn_portable (__NR_SYSCALL_BASE_portable+119)
#define __NR_clone_portable (__NR_SYSCALL_BASE_portable+120)
#define __NR_setdomainname_portable (__NR_SYSCALL_BASE_portable+121)
#define __NR_uname_portable (__NR_SYSCALL_BASE_portable+122)

#define __NR_adjtimex_portable (__NR_SYSCALL_BASE_portable+124)
#define __NR_mprotect_portable (__NR_SYSCALL_BASE_portable+125)
#define __NR_sigprocmask_portable (__NR_SYSCALL_BASE_portable+126)

#define __NR_init_module_portable (__NR_SYSCALL_BASE_portable+128)
#define __NR_delete_module_portable (__NR_SYSCALL_BASE_portable+129)

#define __NR_quotactl_portable (__NR_SYSCALL_BASE_portable+131)
#define __NR_getpgid_portable (__NR_SYSCALL_BASE_portable+132)
#define __NR_fchdir_portable (__NR_SYSCALL_BASE_portable+133)
#define __NR_bdflush_portable (__NR_SYSCALL_BASE_portable+134)
#define __NR_sysfs_portable (__NR_SYSCALL_BASE_portable+135)
#define __NR_personality_portable (__NR_SYSCALL_BASE_portable+136)

#define __NR_setfsuid_portable (__NR_SYSCALL_BASE_portable+138)
#define __NR_setfsgid_portable (__NR_SYSCALL_BASE_portable+139)
#define __NR__llseek_portable (__NR_SYSCALL_BASE_portable+140)
#define __NR_getdents_portable (__NR_SYSCALL_BASE_portable+141)
#define __NR__newselect_portable (__NR_SYSCALL_BASE_portable+142)
#define __NR_flock_portable (__NR_SYSCALL_BASE_portable+143)
#define __NR_msync_portable (__NR_SYSCALL_BASE_portable+144)
#define __NR_readv_portable (__NR_SYSCALL_BASE_portable+145)
#define __NR_writev_portable (__NR_SYSCALL_BASE_portable+146)
#define __NR_getsid_portable (__NR_SYSCALL_BASE_portable+147)
#define __NR_fdatasync_portable (__NR_SYSCALL_BASE_portable+148)
#define __NR__sysctl_portable (__NR_SYSCALL_BASE_portable+149)
#define __NR_mlock_portable (__NR_SYSCALL_BASE_portable+150)
#define __NR_munlock_portable (__NR_SYSCALL_BASE_portable+151)
#define __NR_mlockall_portable (__NR_SYSCALL_BASE_portable+152)
#define __NR_munlockall_portable (__NR_SYSCALL_BASE_portable+153)
#define __NR_sched_setparam_portable (__NR_SYSCALL_BASE_portable+154)
#define __NR_sched_getparam_portable (__NR_SYSCALL_BASE_portable+155)
#define __NR_sched_setscheduler_portable (__NR_SYSCALL_BASE_portable+156)
#define __NR_sched_getscheduler_portable (__NR_SYSCALL_BASE_portable+157)
#define __NR_sched_yield_portable (__NR_SYSCALL_BASE_portable+158)
#define __NR_sched_get_priority_max_portable (__NR_SYSCALL_BASE_portable+159)
#define __NR_sched_get_priority_min_portable (__NR_SYSCALL_BASE_portable+160)
#define __NR_sched_rr_get_interval_portable (__NR_SYSCALL_BASE_portable+161)
#define __NR_nanosleep_portable (__NR_SYSCALL_BASE_portable+162)
#define __NR_mremap_portable (__NR_SYSCALL_BASE_portable+163)
#define __NR_setresuid_portable (__NR_SYSCALL_BASE_portable+164)
#define __NR_getresuid_portable (__NR_SYSCALL_BASE_portable+165)

#define __NR_poll_portable (__NR_SYSCALL_BASE_portable+168)
#define __NR_nfsservctl_portable (__NR_SYSCALL_BASE_portable+169)
#define __NR_setresgid_portable (__NR_SYSCALL_BASE_portable+170)
#define __NR_getresgid_portable (__NR_SYSCALL_BASE_portable+171)
#define __NR_prctl_portable (__NR_SYSCALL_BASE_portable+172)
#define __NR_rt_sigreturn_portable (__NR_SYSCALL_BASE_portable+173)
#define __NR_rt_sigaction_portable (__NR_SYSCALL_BASE_portable+174)
#define __NR_rt_sigprocmask_portable (__NR_SYSCALL_BASE_portable+175)
#define __NR_rt_sigpending_portable (__NR_SYSCALL_BASE_portable+176)
#define __NR_rt_sigtimedwait_portable (__NR_SYSCALL_BASE_portable+177)
#define __NR_rt_sigqueueinfo_portable (__NR_SYSCALL_BASE_portable+178)
#define __NR_rt_sigsuspend_portable (__NR_SYSCALL_BASE_portable+179)
#define __NR_pread64_portable (__NR_SYSCALL_BASE_portable+180)
#define __NR_pwrite64_portable (__NR_SYSCALL_BASE_portable+181)
#define __NR_chown_portable (__NR_SYSCALL_BASE_portable+182)
#define __NR_getcwd_portable (__NR_SYSCALL_BASE_portable+183)
#define __NR_capget_portable (__NR_SYSCALL_BASE_portable+184)
#define __NR_capset_portable (__NR_SYSCALL_BASE_portable+185)
#define __NR_sigaltstack_portable (__NR_SYSCALL_BASE_portable+186)
#define __NR_sendfile_portable (__NR_SYSCALL_BASE_portable+187)

#define __NR_vfork_portable (__NR_SYSCALL_BASE_portable+190)
#define __NR_ugetrlimit_portable (__NR_SYSCALL_BASE_portable+191)
#define __NR_mmap2_portable (__NR_SYSCALL_BASE_portable+192)
#define __NR_truncate64_portable (__NR_SYSCALL_BASE_portable+193)
#define __NR_ftruncate64_portable (__NR_SYSCALL_BASE_portable+194)
#define __NR_stat64_portable (__NR_SYSCALL_BASE_portable+195)
#define __NR_lstat64_portable (__NR_SYSCALL_BASE_portable+196)
#define __NR_fstat64_portable (__NR_SYSCALL_BASE_portable+197)
#define __NR_lchown32_portable (__NR_SYSCALL_BASE_portable+198)
#define __NR_getuid32_portable (__NR_SYSCALL_BASE_portable+199)
#define __NR_getgid32_portable (__NR_SYSCALL_BASE_portable+200)
#define __NR_geteuid32_portable (__NR_SYSCALL_BASE_portable+201)
#define __NR_getegid32_portable (__NR_SYSCALL_BASE_portable+202)
#define __NR_setreuid32_portable (__NR_SYSCALL_BASE_portable+203)
#define __NR_setregid32_portable (__NR_SYSCALL_BASE_portable+204)
#define __NR_getgroups32_portable (__NR_SYSCALL_BASE_portable+205)
#define __NR_setgroups32_portable (__NR_SYSCALL_BASE_portable+206)
#define __NR_fchown32_portable (__NR_SYSCALL_BASE_portable+207)
#define __NR_setresuid32_portable (__NR_SYSCALL_BASE_portable+208)
#define __NR_getresuid32_portable (__NR_SYSCALL_BASE_portable+209)
#define __NR_setresgid32_portable (__NR_SYSCALL_BASE_portable+210)
#define __NR_getresgid32_portable (__NR_SYSCALL_BASE_portable+211)
#define __NR_chown32_portable (__NR_SYSCALL_BASE_portable+212)
#define __NR_setuid32_portable (__NR_SYSCALL_BASE_portable+213)
#define __NR_setgid32_portable (__NR_SYSCALL_BASE_portable+214)
#define __NR_setfsuid32_portable (__NR_SYSCALL_BASE_portable+215)
#define __NR_setfsgid32_portable (__NR_SYSCALL_BASE_portable+216)
#define __NR_getdents64_portable (__NR_SYSCALL_BASE_portable+217)
#define __NR_pivot_root_portable (__NR_SYSCALL_BASE_portable+218)
#define __NR_mincore_portable (__NR_SYSCALL_BASE_portable+219)
#define __NR_madvise_portable (__NR_SYSCALL_BASE_portable+220)
#define __NR_fcntl64_portable (__NR_SYSCALL_BASE_portable+221)

#define __NR_gettid_portable (__NR_SYSCALL_BASE_portable+224)
#define __NR_readahead_portable (__NR_SYSCALL_BASE_portable+225)
#define __NR_setxattr_portable (__NR_SYSCALL_BASE_portable+226)
#define __NR_lsetxattr_portable (__NR_SYSCALL_BASE_portable+227)
#define __NR_fsetxattr_portable (__NR_SYSCALL_BASE_portable+228)
#define __NR_getxattr_portable (__NR_SYSCALL_BASE_portable+229)
#define __NR_lgetxattr_portable (__NR_SYSCALL_BASE_portable+230)
#define __NR_fgetxattr_portable (__NR_SYSCALL_BASE_portable+231)
#define __NR_listxattr_portable (__NR_SYSCALL_BASE_portable+232)
#define __NR_llistxattr_portable (__NR_SYSCALL_BASE_portable+233)
#define __NR_flistxattr_portable (__NR_SYSCALL_BASE_portable+234)
#define __NR_removexattr_portable (__NR_SYSCALL_BASE_portable+235)
#define __NR_lremovexattr_portable (__NR_SYSCALL_BASE_portable+236)
#define __NR_fremovexattr_portable (__NR_SYSCALL_BASE_portable+237)
#define __NR_tkill_portable (__NR_SYSCALL_BASE_portable+238)
#define __NR_sendfile64_portable (__NR_SYSCALL_BASE_portable+239)
#define __NR_futex_portable (__NR_SYSCALL_BASE_portable+240)
#define __NR_sched_setaffinity_portable (__NR_SYSCALL_BASE_portable+241)
#define __NR_sched_getaffinity_portable (__NR_SYSCALL_BASE_portable+242)
#define __NR_io_setup_portable (__NR_SYSCALL_BASE_portable+243)
#define __NR_io_destroy_portable (__NR_SYSCALL_BASE_portable+244)
#define __NR_io_getevents_portable (__NR_SYSCALL_BASE_portable+245)
#define __NR_io_submit_portable (__NR_SYSCALL_BASE_portable+246)
#define __NR_io_cancel_portable (__NR_SYSCALL_BASE_portable+247)
#define __NR_exit_group_portable (__NR_SYSCALL_BASE_portable+248)
#define __NR_lookup_dcookie_portable (__NR_SYSCALL_BASE_portable+249)
#define __NR_epoll_create_portable (__NR_SYSCALL_BASE_portable+250)
#define __NR_epoll_ctl_portable (__NR_SYSCALL_BASE_portable+251)
#define __NR_epoll_wait_portable (__NR_SYSCALL_BASE_portable+252)
#define __NR_remap_file_pages_portable (__NR_SYSCALL_BASE_portable+253)

#define __NR_set_tid_address_portable (__NR_SYSCALL_BASE_portable+256)
#define __NR_timer_create_portable (__NR_SYSCALL_BASE_portable+257)
#define __NR_timer_settime_portable (__NR_SYSCALL_BASE_portable+258)
#define __NR_timer_gettime_portable (__NR_SYSCALL_BASE_portable+259)
#define __NR_timer_getoverrun_portable (__NR_SYSCALL_BASE_portable+260)
#define __NR_timer_delete_portable (__NR_SYSCALL_BASE_portable+261)
#define __NR_clock_settime_portable (__NR_SYSCALL_BASE_portable+262)
#define __NR_clock_gettime_portable (__NR_SYSCALL_BASE_portable+263)
#define __NR_clock_getres_portable (__NR_SYSCALL_BASE_portable+264)
#define __NR_clock_nanosleep_portable (__NR_SYSCALL_BASE_portable+265)
#define __NR_statfs64_portable (__NR_SYSCALL_BASE_portable+266)
#define __NR_fstatfs64_portable (__NR_SYSCALL_BASE_portable+267)
#define __NR_tgkill_portable (__NR_SYSCALL_BASE_portable+268)
#define __NR_utimes_portable (__NR_SYSCALL_BASE_portable+269)
#define __NR_arm_fadvise64_64_portable (__NR_SYSCALL_BASE_portable+270)
#define __NR_pciconfig_iobase_portable (__NR_SYSCALL_BASE_portable+271)
#define __NR_pciconfig_read_portable (__NR_SYSCALL_BASE_portable+272)
#define __NR_pciconfig_write_portable (__NR_SYSCALL_BASE_portable+273)
#define __NR_mq_open_portable (__NR_SYSCALL_BASE_portable+274)
#define __NR_mq_unlink_portable (__NR_SYSCALL_BASE_portable+275)
#define __NR_mq_timedsend_portable (__NR_SYSCALL_BASE_portable+276)
#define __NR_mq_timedreceive_portable (__NR_SYSCALL_BASE_portable+277)
#define __NR_mq_notify_portable (__NR_SYSCALL_BASE_portable+278)
#define __NR_mq_getsetattr_portable (__NR_SYSCALL_BASE_portable+279)
#define __NR_waitid_portable (__NR_SYSCALL_BASE_portable+280)
#define __NR_socket_portable (__NR_SYSCALL_BASE_portable+281)
#define __NR_bind_portable (__NR_SYSCALL_BASE_portable+282)
#define __NR_connect_portable (__NR_SYSCALL_BASE_portable+283)
#define __NR_listen_portable (__NR_SYSCALL_BASE_portable+284)
#define __NR_accept_portable (__NR_SYSCALL_BASE_portable+285)
#define __NR_getsockname_portable (__NR_SYSCALL_BASE_portable+286)
#define __NR_getpeername_portable (__NR_SYSCALL_BASE_portable+287)
#define __NR_socketpair_portable (__NR_SYSCALL_BASE_portable+288)
#define __NR_send_portable (__NR_SYSCALL_BASE_portable+289)
#define __NR_sendto_portable (__NR_SYSCALL_BASE_portable+290)
#define __NR_recv_portable (__NR_SYSCALL_BASE_portable+291)
#define __NR_recvfrom_portable (__NR_SYSCALL_BASE_portable+292)
#define __NR_shutdown_portable (__NR_SYSCALL_BASE_portable+293)
#define __NR_setsockopt_portable (__NR_SYSCALL_BASE_portable+294)
#define __NR_getsockopt_portable (__NR_SYSCALL_BASE_portable+295)
#define __NR_sendmsg_portable (__NR_SYSCALL_BASE_portable+296)
#define __NR_recvmsg_portable (__NR_SYSCALL_BASE_portable+297)
#define __NR_semop_portable (__NR_SYSCALL_BASE_portable+298)
#define __NR_semget_portable (__NR_SYSCALL_BASE_portable+299)
#define __NR_semctl_portable (__NR_SYSCALL_BASE_portable+300)
#define __NR_msgsnd_portable (__NR_SYSCALL_BASE_portable+301)
#define __NR_msgrcv_portable (__NR_SYSCALL_BASE_portable+302)
#define __NR_msgget_portable (__NR_SYSCALL_BASE_portable+303)
#define __NR_msgctl_portable (__NR_SYSCALL_BASE_portable+304)
#define __NR_shmat_portable (__NR_SYSCALL_BASE_portable+305)
#define __NR_shmdt_portable (__NR_SYSCALL_BASE_portable+306)
#define __NR_shmget_portable (__NR_SYSCALL_BASE_portable+307)
#define __NR_shmctl_portable (__NR_SYSCALL_BASE_portable+308)
#define __NR_add_key_portable (__NR_SYSCALL_BASE_portable+309)
#define __NR_request_key_portable (__NR_SYSCALL_BASE_portable+310)
#define __NR_keyctl_portable (__NR_SYSCALL_BASE_portable+311)
#define __NR_semtimedop_portable (__NR_SYSCALL_BASE_portable+312)
#define __NR_vserver_portable (__NR_SYSCALL_BASE_portable+313)
#define __NR_ioprio_set_portable (__NR_SYSCALL_BASE_portable+314)
#define __NR_ioprio_get_portable (__NR_SYSCALL_BASE_portable+315)
#define __NR_inotify_init_portable (__NR_SYSCALL_BASE_portable+316)
#define __NR_inotify_add_watch_portable (__NR_SYSCALL_BASE_portable+317)
#define __NR_inotify_rm_watch_portable (__NR_SYSCALL_BASE_portable+318)
#define __NR_mbind_portable (__NR_SYSCALL_BASE_portable+319)
#define __NR_get_mempolicy_portable (__NR_SYSCALL_BASE_portable+320)
#define __NR_set_mempolicy_portable (__NR_SYSCALL_BASE_portable+321)

#define  __NR_openat_portable (__NR_SYSCALL_BASE_portable+322)
#define  __NR_mkdirat_portable (__NR_SYSCALL_BASE_portable+323)
#define  __NR_mknodat_portable (__NR_SYSCALL_BASE_portable+324)
#define  __NR_fchownat_portable (__NR_SYSCALL_BASE_portable+325)
#define  __NR_futimesat_portable (__NR_SYSCALL_BASE_portable+326)
#define  __NR_fstatat64_portable (__NR_SYSCALL_BASE_portable+327)
#define  __NR_unlinkat_portable (__NR_SYSCALL_BASE_portable+328)
#define  __NR_renameat_portable (__NR_SYSCALL_BASE_portable+329)
#define  __NR_linkat_portable (__NR_SYSCALL_BASE_portable+330)
#define  __NR_symlinkat_portable (__NR_SYSCALL_BASE_portable+331)
#define  __NR_readlinkat_portable (__NR_SYSCALL_BASE_portable+332)
#define  __NR_fchmodat_portable (__NR_SYSCALL_BASE_portable+333)
#define  __NR_faccessat_portable (__NR_SYSCALL_BASE_portable+334)
#define  __NR_pselect6_portable (__NR_SYSCALL_BASE_portable+335)
#define  __NR_ppoll_portable (__NR_SYSCALL_BASE_portable+336)
#define  __NR_unshare_portable (__NR_SYSCALL_BASE_portable+337)
#define  __NR_set_robust_list_portable (__NR_SYSCALL_BASE_portable+338)
#define  __NR_get_robust_list_portable (__NR_SYSCALL_BASE_portable+339)
#define  __NR_splice_portable (__NR_SYSCALL_BASE_portable+340)
#define  __NR_arm_sync_file_range_portable (__NR_SYSCALL_BASE_portable+341)
#define  __NR_tee_portable (__NR_SYSCALL_BASE_portable+342)
#define  __NR_vmsplice_portable (__NR_SYSCALL_BASE_portable+343)
#define  __NR_move_pages_portable (__NR_SYSCALL_BASE_portable+344)
#define  __NR_getcpu_portable (__NR_SYSCALL_BASE_portable+345)
#define  __NR_epoll_pwait_portable (__NR_SYSCALL_BASE_portable+346)
#define  __NR_kexec_load_portable (__NR_SYSCALL_BASE_portable+347)
#define  __NR_utimensat_portable (__NR_SYSCALL_BASE_portable+348)
#define  __NR_signalfd_portable (__NR_SYSCALL_BASE_portable+349)
#define  __NR_timerfd_create_portable (__NR_SYSCALL_BASE_portable+350)
#define  __NR_eventfd_portable (__NR_SYSCALL_BASE_portable+351)
#define  __NR_fallocate_portable (__NR_SYSCALL_BASE_portable+352)
#define  __NR_timerfd_settime_portable (__NR_SYSCALL_BASE_portable+353)
#define  __NR_timerfd_gettime_portable (__NR_SYSCALL_BASE_portable+354)
#define  __NR_signalfd4_portable (__NR_SYSCALL_BASE_portable+355)
#define  __NR_eventfd2_portable (__NR_SYSCALL_BASE_portable+356)
#define  __NR_epoll_create1_portable (__NR_SYSCALL_BASE_portable+357)
#define  __NR_dup3_portable (__NR_SYSCALL_BASE_portable+358)
#define  __NR_pipe2_portable (__NR_SYSCALL_BASE_portable+359)
#define  __NR_inotify_init1_portable (__NR_SYSCALL_BASE_portable+360)
#define  __NR_preadv_portable (__NR_SYSCALL_BASE_portable+361)
#define  __NR_pwritev_portable (__NR_SYSCALL_BASE_portable+362)
#define  __NR_rt_tgsigqueueinfo_portable (__NR_SYSCALL_BASE_portable+363)
#define  __NR_perf_event_open_portable (__NR_SYSCALL_BASE_portable+364)
#define  __NR_recvmmsg_portable (__NR_SYSCALL_BASE_portable+365)
#define  __NR_accept4_portable (__NR_SYSCALL_BASE_portable+366)
#define  __NR_fanotify_init_portable (__NR_SYSCALL_BASE_portable+367)
#define  __NR_fanotify_mark_portable (__NR_SYSCALL_BASE_portable+368)
#define  __NR_prlimit64_portable (__NR_SYSCALL_BASE_portable+369)
#define  __NR_name_to_handle_at_portable (__NR_SYSCALL_BASE_portable+370)
#define  __NR_open_by_handle_at_portable (__NR_SYSCALL_BASE_portable+371)
#define  __NR_clock_adjtime_portable (__NR_SYSCALL_BASE_portable+372)
#define  __NR_syncfs_portable (__NR_SYSCALL_BASE_portable+373)
#define  __NR_sendmmsg_portable (__NR_SYSCALL_BASE_portable+374)
#define  __NR_setns_portable (__NR_SYSCALL_BASE_portable+375)
#define  __NR_process_vm_readv_portable (__NR_SYSCALL_BASE_portable+376)
#define  __NR_process_vm_writev_portable (__NR_SYSCALL_BASE_portable+377)


#define __ARM_NR_BASE_portable (__NR_SYSCALL_BASE_portable+0x0f0000)
#define __ARM_NR_breakpoint_portable (__ARM_NR_BASE_portable+1)
#define __ARM_NR_cacheflush_portable (__ARM_NR_BASE_portable+2)
#define __ARM_NR_usr26_portable (__ARM_NR_BASE_portable+3)
#define __ARM_NR_usr32_portable (__ARM_NR_BASE_portable+4)
#define __ARM_NR_set_tls_portable (__ARM_NR_BASE_portable+5)

/* Apparently these are not callable using syscall on ARM... */
#undef __NR_time_portable
#undef __NR_umount_portable
#undef __NR_stime_portable
#undef __NR_alarm_portable
#undef __NR_utime_portable
#undef __NR_getrlimit_portable
#undef __NR_select_portable
#undef __NR_readdir_portable
#undef __NR_mmap_portable
#undef __NR_socketcall_portable
#undef __NR_syscall_portable
#undef __NR_ipc_portable

#endif
