/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

 /*! \mainpage notitle
  *
  * RenderScript is a high-performance runtime that provides
  * compute operations at the native level. RenderScript code is compiled on devices
  * at runtime to allow platform-independence as well.
  * This reference documentation describes the RenderScript runtime APIs, which you
  * can utilize to write RenderScript code in C99. The RenderScript compute header
  * files are automatically included for you.
  *
  */

#ifndef ANDROID_RENDERSCRIPT_H
#define ANDROID_RENDERSCRIPT_H

#include "rsCppStructs.h"

#ifdef RS_SERVER
#define RS_VERSION 19
#endif

#endif
