/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGM17ModSettings.h
 *
 * M17Mod
 */

#ifndef SWGM17ModSettings_H_
#define SWGM17ModSettings_H_

#include <QJsonObject>


#include "SWGChannelMarker.h"
#include "SWGRollupState.h"
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGM17ModSettings: public SWGObject {
public:
    SWGM17ModSettings();
    SWGM17ModSettings(QString* json);
    virtual ~SWGM17ModSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGM17ModSettings* fromJson(QString &jsonString) override;

    qint64 getInputFrequencyOffset();
    void setInputFrequencyOffset(qint64 input_frequency_offset);

    float getRfBandwidth();
    void setRfBandwidth(float rf_bandwidth);

    float getFmDeviation();
    void setFmDeviation(float fm_deviation);

    float getToneFrequency();
    void setToneFrequency(float tone_frequency);

    float getVolumeFactor();
    void setVolumeFactor(float volume_factor);

    qint32 getChannelMute();
    void setChannelMute(qint32 channel_mute);

    qint32 getPlayLoop();
    void setPlayLoop(qint32 play_loop);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getM17Mode();
    void setM17Mode(qint32 m17_mode);

    qint32 getAudioType();
    void setAudioType(qint32 audio_type);

    qint32 getPacketType();
    void setPacketType(qint32 packet_type);

    QString* getAudioDeviceName();
    void setAudioDeviceName(QString* audio_device_name);

    QString* getFeedbackAudioDeviceName();
    void setFeedbackAudioDeviceName(QString* feedback_audio_device_name);

    float getFeedbackVolumeFactor();
    void setFeedbackVolumeFactor(float feedback_volume_factor);

    qint32 getFeedbackAudioEnable();
    void setFeedbackAudioEnable(qint32 feedback_audio_enable);

    qint32 getStreamIndex();
    void setStreamIndex(qint32 stream_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);

    QString* getSourceCall();
    void setSourceCall(QString* source_call);

    QString* getDestCall();
    void setDestCall(QString* dest_call);

    qint32 getInsertPosition();
    void setInsertPosition(qint32 insert_position);

    qint32 getCan();
    void setCan(qint32 can);

    QString* getSmsText();
    void setSmsText(QString* sms_text);

    qint32 getLoopPacket();
    void setLoopPacket(qint32 loop_packet);

    qint32 getLoopPacketInterval();
    void setLoopPacketInterval(qint32 loop_packet_interval);

    QString* getAprsCallsign();
    void setAprsCallsign(QString* aprs_callsign);

    QString* getAprsTo();
    void setAprsTo(QString* aprs_to);

    QString* getAprsVia();
    void setAprsVia(QString* aprs_via);

    QString* getAprsData();
    void setAprsData(QString* aprs_data);

    qint32 getAprsInsertPosition();
    void setAprsInsertPosition(qint32 aprs_insert_position);

    SWGChannelMarker* getChannelMarker();
    void setChannelMarker(SWGChannelMarker* channel_marker);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);


    virtual bool isSet() override;

private:
    qint64 input_frequency_offset;
    bool m_input_frequency_offset_isSet;

    float rf_bandwidth;
    bool m_rf_bandwidth_isSet;

    float fm_deviation;
    bool m_fm_deviation_isSet;

    float tone_frequency;
    bool m_tone_frequency_isSet;

    float volume_factor;
    bool m_volume_factor_isSet;

    qint32 channel_mute;
    bool m_channel_mute_isSet;

    qint32 play_loop;
    bool m_play_loop_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 m17_mode;
    bool m_m17_mode_isSet;

    qint32 audio_type;
    bool m_audio_type_isSet;

    qint32 packet_type;
    bool m_packet_type_isSet;

    QString* audio_device_name;
    bool m_audio_device_name_isSet;

    QString* feedback_audio_device_name;
    bool m_feedback_audio_device_name_isSet;

    float feedback_volume_factor;
    bool m_feedback_volume_factor_isSet;

    qint32 feedback_audio_enable;
    bool m_feedback_audio_enable_isSet;

    qint32 stream_index;
    bool m_stream_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

    QString* source_call;
    bool m_source_call_isSet;

    QString* dest_call;
    bool m_dest_call_isSet;

    qint32 insert_position;
    bool m_insert_position_isSet;

    qint32 can;
    bool m_can_isSet;

    QString* sms_text;
    bool m_sms_text_isSet;

    qint32 loop_packet;
    bool m_loop_packet_isSet;

    qint32 loop_packet_interval;
    bool m_loop_packet_interval_isSet;

    QString* aprs_callsign;
    bool m_aprs_callsign_isSet;

    QString* aprs_to;
    bool m_aprs_to_isSet;

    QString* aprs_via;
    bool m_aprs_via_isSet;

    QString* aprs_data;
    bool m_aprs_data_isSet;

    qint32 aprs_insert_position;
    bool m_aprs_insert_position_isSet;

    SWGChannelMarker* channel_marker;
    bool m_channel_marker_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

};

}

#endif /* SWGM17ModSettings_H_ */
