/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGPERTesterActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGPERTesterActions::SWGPERTesterActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGPERTesterActions::SWGPERTesterActions() {
    run = 0;
    m_run_isSet = false;
    aos = nullptr;
    m_aos_isSet = false;
}

SWGPERTesterActions::~SWGPERTesterActions() {
    this->cleanup();
}

void
SWGPERTesterActions::init() {
    run = 0;
    m_run_isSet = false;
    aos = new SWGPERTesterActions_aos();
    m_aos_isSet = false;
}

void
SWGPERTesterActions::cleanup() {

    if(aos != nullptr) { 
        delete aos;
    }
}

SWGPERTesterActions*
SWGPERTesterActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGPERTesterActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&run, pJson["run"], "qint32", "");
    
    ::SWGSDRangel::setValue(&aos, pJson["aos"], "SWGPERTesterActions_aos", "SWGPERTesterActions_aos");
    
}

QString
SWGPERTesterActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGPERTesterActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_run_isSet){
        obj->insert("run", QJsonValue(run));
    }
    if((aos != nullptr) && (aos->isSet())){
        toJsonValue(QString("aos"), aos, obj, QString("SWGPERTesterActions_aos"));
    }

    return obj;
}

qint32
SWGPERTesterActions::getRun() {
    return run;
}
void
SWGPERTesterActions::setRun(qint32 run) {
    this->run = run;
    this->m_run_isSet = true;
}

SWGPERTesterActions_aos*
SWGPERTesterActions::getAos() {
    return aos;
}
void
SWGPERTesterActions::setAos(SWGPERTesterActions_aos* aos) {
    this->aos = aos;
    this->m_aos_isSet = true;
}


bool
SWGPERTesterActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_run_isSet){
            isObjectUpdated = true; break;
        }
        if(aos && aos->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

