/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGFeatureActions.h
 *
 * Base feature actions. Only the feature actions corresponding to the feature specified in the featureType field is or should be present.
 */

#ifndef SWGFeatureActions_H_
#define SWGFeatureActions_H_

#include <QJsonObject>


#include "SWGAFCActions.h"
#include "SWGGS232ControllerActions.h"
#include "SWGMapActions.h"
#include "SWGPERTesterActions.h"
#include "SWGRigCtlServerActions.h"
#include "SWGSatelliteTrackerActions.h"
#include "SWGSimplePTTActions.h"
#include "SWGStarTrackerActions.h"
#include "SWGVORLocalizerActions.h"
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGFeatureActions: public SWGObject {
public:
    SWGFeatureActions();
    SWGFeatureActions(QString* json);
    virtual ~SWGFeatureActions();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGFeatureActions* fromJson(QString &jsonString) override;

    QString* getFeatureType();
    void setFeatureType(QString* feature_type);

    qint32 getOriginatorFeatureSetIndex();
    void setOriginatorFeatureSetIndex(qint32 originator_feature_set_index);

    qint32 getOriginatorFeatureIndex();
    void setOriginatorFeatureIndex(qint32 originator_feature_index);

    SWGAFCActions* getAfcActions();
    void setAfcActions(SWGAFCActions* afc_actions);

    SWGGS232ControllerActions* getGs232ControllerActions();
    void setGs232ControllerActions(SWGGS232ControllerActions* gs232_controller_actions);

    SWGMapActions* getMapActions();
    void setMapActions(SWGMapActions* map_actions);

    SWGPERTesterActions* getPerTesterActions();
    void setPerTesterActions(SWGPERTesterActions* per_tester_actions);

    SWGRigCtlServerActions* getRigCtlServerActions();
    void setRigCtlServerActions(SWGRigCtlServerActions* rig_ctl_server_actions);

    SWGSatelliteTrackerActions* getSatelliteTrackerActions();
    void setSatelliteTrackerActions(SWGSatelliteTrackerActions* satellite_tracker_actions);

    SWGSimplePTTActions* getSimplePttActions();
    void setSimplePttActions(SWGSimplePTTActions* simple_ptt_actions);

    SWGStarTrackerActions* getStarTrackerActions();
    void setStarTrackerActions(SWGStarTrackerActions* star_tracker_actions);

    SWGVORLocalizerActions* getVorLocalizerActions();
    void setVorLocalizerActions(SWGVORLocalizerActions* vor_localizer_actions);


    virtual bool isSet() override;

private:
    QString* feature_type;
    bool m_feature_type_isSet;

    qint32 originator_feature_set_index;
    bool m_originator_feature_set_index_isSet;

    qint32 originator_feature_index;
    bool m_originator_feature_index_isSet;

    SWGAFCActions* afc_actions;
    bool m_afc_actions_isSet;

    SWGGS232ControllerActions* gs232_controller_actions;
    bool m_gs232_controller_actions_isSet;

    SWGMapActions* map_actions;
    bool m_map_actions_isSet;

    SWGPERTesterActions* per_tester_actions;
    bool m_per_tester_actions_isSet;

    SWGRigCtlServerActions* rig_ctl_server_actions;
    bool m_rig_ctl_server_actions_isSet;

    SWGSatelliteTrackerActions* satellite_tracker_actions;
    bool m_satellite_tracker_actions_isSet;

    SWGSimplePTTActions* simple_ptt_actions;
    bool m_simple_ptt_actions_isSet;

    SWGStarTrackerActions* star_tracker_actions;
    bool m_star_tracker_actions_isSet;

    SWGVORLocalizerActions* vor_localizer_actions;
    bool m_vor_localizer_actions_isSet;

};

}

#endif /* SWGFeatureActions_H_ */
