/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGXtrxMIMOReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGXtrxMIMOReport::SWGXtrxMIMOReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGXtrxMIMOReport::SWGXtrxMIMOReport() {
    success = 0;
    m_success_isSet = false;
    fifo_size = 0;
    m_fifo_size_isSet = false;
    fifo_fill_rx = 0;
    m_fifo_fill_rx_isSet = false;
    fifo_fill_tx = 0;
    m_fifo_fill_tx_isSet = false;
    temperature = 0.0f;
    m_temperature_isSet = false;
    gps_lock = 0;
    m_gps_lock_isSet = false;
    actual_input_rate = 0;
    m_actual_input_rate_isSet = false;
    actual_output_rate = 0;
    m_actual_output_rate_isSet = false;
    clock_gen_rate = 0;
    m_clock_gen_rate_isSet = false;
}

SWGXtrxMIMOReport::~SWGXtrxMIMOReport() {
    this->cleanup();
}

void
SWGXtrxMIMOReport::init() {
    success = 0;
    m_success_isSet = false;
    fifo_size = 0;
    m_fifo_size_isSet = false;
    fifo_fill_rx = 0;
    m_fifo_fill_rx_isSet = false;
    fifo_fill_tx = 0;
    m_fifo_fill_tx_isSet = false;
    temperature = 0.0f;
    m_temperature_isSet = false;
    gps_lock = 0;
    m_gps_lock_isSet = false;
    actual_input_rate = 0;
    m_actual_input_rate_isSet = false;
    actual_output_rate = 0;
    m_actual_output_rate_isSet = false;
    clock_gen_rate = 0;
    m_clock_gen_rate_isSet = false;
}

void
SWGXtrxMIMOReport::cleanup() {









}

SWGXtrxMIMOReport*
SWGXtrxMIMOReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGXtrxMIMOReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&success, pJson["success"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fifo_size, pJson["fifoSize"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fifo_fill_rx, pJson["fifoFillRx"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fifo_fill_tx, pJson["fifoFillTx"], "qint32", "");
    
    ::SWGSDRangel::setValue(&temperature, pJson["temperature"], "float", "");
    
    ::SWGSDRangel::setValue(&gps_lock, pJson["gpsLock"], "qint32", "");
    
    ::SWGSDRangel::setValue(&actual_input_rate, pJson["actualInputRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&actual_output_rate, pJson["actualOutputRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&clock_gen_rate, pJson["clockGenRate"], "qint32", "");
    
}

QString
SWGXtrxMIMOReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGXtrxMIMOReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_success_isSet){
        obj->insert("success", QJsonValue(success));
    }
    if(m_fifo_size_isSet){
        obj->insert("fifoSize", QJsonValue(fifo_size));
    }
    if(m_fifo_fill_rx_isSet){
        obj->insert("fifoFillRx", QJsonValue(fifo_fill_rx));
    }
    if(m_fifo_fill_tx_isSet){
        obj->insert("fifoFillTx", QJsonValue(fifo_fill_tx));
    }
    if(m_temperature_isSet){
        obj->insert("temperature", QJsonValue(temperature));
    }
    if(m_gps_lock_isSet){
        obj->insert("gpsLock", QJsonValue(gps_lock));
    }
    if(m_actual_input_rate_isSet){
        obj->insert("actualInputRate", QJsonValue(actual_input_rate));
    }
    if(m_actual_output_rate_isSet){
        obj->insert("actualOutputRate", QJsonValue(actual_output_rate));
    }
    if(m_clock_gen_rate_isSet){
        obj->insert("clockGenRate", QJsonValue(clock_gen_rate));
    }

    return obj;
}

qint32
SWGXtrxMIMOReport::getSuccess() {
    return success;
}
void
SWGXtrxMIMOReport::setSuccess(qint32 success) {
    this->success = success;
    this->m_success_isSet = true;
}

qint32
SWGXtrxMIMOReport::getFifoSize() {
    return fifo_size;
}
void
SWGXtrxMIMOReport::setFifoSize(qint32 fifo_size) {
    this->fifo_size = fifo_size;
    this->m_fifo_size_isSet = true;
}

qint32
SWGXtrxMIMOReport::getFifoFillRx() {
    return fifo_fill_rx;
}
void
SWGXtrxMIMOReport::setFifoFillRx(qint32 fifo_fill_rx) {
    this->fifo_fill_rx = fifo_fill_rx;
    this->m_fifo_fill_rx_isSet = true;
}

qint32
SWGXtrxMIMOReport::getFifoFillTx() {
    return fifo_fill_tx;
}
void
SWGXtrxMIMOReport::setFifoFillTx(qint32 fifo_fill_tx) {
    this->fifo_fill_tx = fifo_fill_tx;
    this->m_fifo_fill_tx_isSet = true;
}

float
SWGXtrxMIMOReport::getTemperature() {
    return temperature;
}
void
SWGXtrxMIMOReport::setTemperature(float temperature) {
    this->temperature = temperature;
    this->m_temperature_isSet = true;
}

qint32
SWGXtrxMIMOReport::getGpsLock() {
    return gps_lock;
}
void
SWGXtrxMIMOReport::setGpsLock(qint32 gps_lock) {
    this->gps_lock = gps_lock;
    this->m_gps_lock_isSet = true;
}

qint32
SWGXtrxMIMOReport::getActualInputRate() {
    return actual_input_rate;
}
void
SWGXtrxMIMOReport::setActualInputRate(qint32 actual_input_rate) {
    this->actual_input_rate = actual_input_rate;
    this->m_actual_input_rate_isSet = true;
}

qint32
SWGXtrxMIMOReport::getActualOutputRate() {
    return actual_output_rate;
}
void
SWGXtrxMIMOReport::setActualOutputRate(qint32 actual_output_rate) {
    this->actual_output_rate = actual_output_rate;
    this->m_actual_output_rate_isSet = true;
}

qint32
SWGXtrxMIMOReport::getClockGenRate() {
    return clock_gen_rate;
}
void
SWGXtrxMIMOReport::setClockGenRate(qint32 clock_gen_rate) {
    this->clock_gen_rate = clock_gen_rate;
    this->m_clock_gen_rate_isSet = true;
}


bool
SWGXtrxMIMOReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_success_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fifo_size_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fifo_fill_rx_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fifo_fill_tx_isSet){
            isObjectUpdated = true; break;
        }
        if(m_temperature_isSet){
            isObjectUpdated = true; break;
        }
        if(m_gps_lock_isSet){
            isObjectUpdated = true; break;
        }
        if(m_actual_input_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_actual_output_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_clock_gen_rate_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

