/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1, USRP and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.15.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGLimeRFEDevices.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGLimeRFEDevices::SWGLimeRFEDevices(QString* json) {
    init();
    this->fromJson(*json);
}

SWGLimeRFEDevices::SWGLimeRFEDevices() {
    nb_devices = 0;
    m_nb_devices_isSet = false;
    lime_rfe_devices = nullptr;
    m_lime_rfe_devices_isSet = false;
}

SWGLimeRFEDevices::~SWGLimeRFEDevices() {
    this->cleanup();
}

void
SWGLimeRFEDevices::init() {
    nb_devices = 0;
    m_nb_devices_isSet = false;
    lime_rfe_devices = new QList<SWGLimeRFEDevice*>();
    m_lime_rfe_devices_isSet = false;
}

void
SWGLimeRFEDevices::cleanup() {

    if(lime_rfe_devices != nullptr) { 
        auto arr = lime_rfe_devices;
        for(auto o: *arr) { 
            delete o;
        }
        delete lime_rfe_devices;
    }
}

SWGLimeRFEDevices*
SWGLimeRFEDevices::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGLimeRFEDevices::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&nb_devices, pJson["nbDevices"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&lime_rfe_devices, pJson["limeRFEDevices"], "QList", "SWGLimeRFEDevice");
}

QString
SWGLimeRFEDevices::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGLimeRFEDevices::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_nb_devices_isSet){
        obj->insert("nbDevices", QJsonValue(nb_devices));
    }
    if(lime_rfe_devices && lime_rfe_devices->size() > 0){
        toJsonArray((QList<void*>*)lime_rfe_devices, obj, "limeRFEDevices", "SWGLimeRFEDevice");
    }

    return obj;
}

qint32
SWGLimeRFEDevices::getNbDevices() {
    return nb_devices;
}
void
SWGLimeRFEDevices::setNbDevices(qint32 nb_devices) {
    this->nb_devices = nb_devices;
    this->m_nb_devices_isSet = true;
}

QList<SWGLimeRFEDevice*>*
SWGLimeRFEDevices::getLimeRfeDevices() {
    return lime_rfe_devices;
}
void
SWGLimeRFEDevices::setLimeRfeDevices(QList<SWGLimeRFEDevice*>* lime_rfe_devices) {
    this->lime_rfe_devices = lime_rfe_devices;
    this->m_lime_rfe_devices_isSet = true;
}


bool
SWGLimeRFEDevices::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_nb_devices_isSet){
            isObjectUpdated = true; break;
        }
        if(lime_rfe_devices && (lime_rfe_devices->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

