/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1, USRP and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.15.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureConfig.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureConfig::SWGFeatureConfig(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureConfig::SWGFeatureConfig() {
    feature_id_uri = nullptr;
    m_feature_id_uri_isSet = false;
    config = nullptr;
    m_config_isSet = false;
}

SWGFeatureConfig::~SWGFeatureConfig() {
    this->cleanup();
}

void
SWGFeatureConfig::init() {
    feature_id_uri = new QString("");
    m_feature_id_uri_isSet = false;
    config = new SWGFeatureSettings();
    m_config_isSet = false;
}

void
SWGFeatureConfig::cleanup() {
    if(feature_id_uri != nullptr) { 
        delete feature_id_uri;
    }
    if(config != nullptr) { 
        delete config;
    }
}

SWGFeatureConfig*
SWGFeatureConfig::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureConfig::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&feature_id_uri, pJson["featureIdURI"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&config, pJson["config"], "SWGFeatureSettings", "SWGFeatureSettings");
    
}

QString
SWGFeatureConfig::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureConfig::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(feature_id_uri != nullptr && *feature_id_uri != QString("")){
        toJsonValue(QString("featureIdURI"), feature_id_uri, obj, QString("QString"));
    }
    if((config != nullptr) && (config->isSet())){
        toJsonValue(QString("config"), config, obj, QString("SWGFeatureSettings"));
    }

    return obj;
}

QString*
SWGFeatureConfig::getFeatureIdUri() {
    return feature_id_uri;
}
void
SWGFeatureConfig::setFeatureIdUri(QString* feature_id_uri) {
    this->feature_id_uri = feature_id_uri;
    this->m_feature_id_uri_isSet = true;
}

SWGFeatureSettings*
SWGFeatureConfig::getConfig() {
    return config;
}
void
SWGFeatureConfig::setConfig(SWGFeatureSettings* config) {
    this->config = config;
    this->m_config_isSet = true;
}


bool
SWGFeatureConfig::isSet(){
    bool isObjectUpdated = false;
    do{
        if(feature_id_uri && *feature_id_uri != QString("")){
            isObjectUpdated = true; break;
        }
        if(config && config->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

