/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.11.6
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGRemoteOutputSettings.h
 *
 * RemoteOutput
 */

#ifndef SWGRemoteOutputSettings_H_
#define SWGRemoteOutputSettings_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGRemoteOutputSettings: public SWGObject {
public:
    SWGRemoteOutputSettings();
    SWGRemoteOutputSettings(QString* json);
    virtual ~SWGRemoteOutputSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGRemoteOutputSettings* fromJson(QString &jsonString) override;

    qint32 getCenterFrequency();
    void setCenterFrequency(qint32 center_frequency);

    qint32 getSampleRate();
    void setSampleRate(qint32 sample_rate);

    float getTxDelay();
    void setTxDelay(float tx_delay);

    qint32 getNbFecBlocks();
    void setNbFecBlocks(qint32 nb_fec_blocks);

    QString* getApiAddress();
    void setApiAddress(QString* api_address);

    qint32 getApiPort();
    void setApiPort(qint32 api_port);

    QString* getDataAddress();
    void setDataAddress(QString* data_address);

    qint32 getDataPort();
    void setDataPort(qint32 data_port);

    qint32 getDeviceIndex();
    void setDeviceIndex(qint32 device_index);

    qint32 getChannelIndex();
    void setChannelIndex(qint32 channel_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);


    virtual bool isSet() override;

private:
    qint32 center_frequency;
    bool m_center_frequency_isSet;

    qint32 sample_rate;
    bool m_sample_rate_isSet;

    float tx_delay;
    bool m_tx_delay_isSet;

    qint32 nb_fec_blocks;
    bool m_nb_fec_blocks_isSet;

    QString* api_address;
    bool m_api_address_isSet;

    qint32 api_port;
    bool m_api_port_isSet;

    QString* data_address;
    bool m_data_address_isSet;

    qint32 data_port;
    bool m_data_port_isSet;

    qint32 device_index;
    bool m_device_index_isSet;

    qint32 channel_index;
    bool m_channel_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

};

}

#endif /* SWGRemoteOutputSettings_H_ */
