/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.11.6
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGPreset.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGPreset::SWGPreset(QString* json) {
    init();
    this->fromJson(*json);
}

SWGPreset::SWGPreset() {
    preset_type = 0;
    m_preset_type_isSet = false;
    group = nullptr;
    m_group_isSet = false;
    description = nullptr;
    m_description_isSet = false;
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    spectrum_config = nullptr;
    m_spectrum_config_isSet = false;
    dc_offset_correction = 0;
    m_dc_offset_correction_isSet = false;
    iq_imbalance_correction = 0;
    m_iq_imbalance_correction_isSet = false;
    channel_configs = nullptr;
    m_channel_configs_isSet = false;
    device_configs = nullptr;
    m_device_configs_isSet = false;
    layout = nullptr;
    m_layout_isSet = false;
}

SWGPreset::~SWGPreset() {
    this->cleanup();
}

void
SWGPreset::init() {
    preset_type = 0;
    m_preset_type_isSet = false;
    group = new QString("");
    m_group_isSet = false;
    description = new QString("");
    m_description_isSet = false;
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    spectrum_config = new SWGGLSpectrum();
    m_spectrum_config_isSet = false;
    dc_offset_correction = 0;
    m_dc_offset_correction_isSet = false;
    iq_imbalance_correction = 0;
    m_iq_imbalance_correction_isSet = false;
    channel_configs = new QList<SWGChannelConfig*>();
    m_channel_configs_isSet = false;
    device_configs = new QList<SWGDeviceConfig*>();
    m_device_configs_isSet = false;
    layout = new QString("");
    m_layout_isSet = false;
}

void
SWGPreset::cleanup() {

    if(group != nullptr) { 
        delete group;
    }
    if(description != nullptr) { 
        delete description;
    }

    if(spectrum_config != nullptr) { 
        delete spectrum_config;
    }


    if(channel_configs != nullptr) { 
        auto arr = channel_configs;
        for(auto o: *arr) { 
            delete o;
        }
        delete channel_configs;
    }
    if(device_configs != nullptr) { 
        auto arr = device_configs;
        for(auto o: *arr) { 
            delete o;
        }
        delete device_configs;
    }
    if(layout != nullptr) { 
        delete layout;
    }
}

SWGPreset*
SWGPreset::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGPreset::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&preset_type, pJson["presetType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&group, pJson["group"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&description, pJson["description"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&center_frequency, pJson["centerFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&spectrum_config, pJson["spectrumConfig"], "SWGGLSpectrum", "SWGGLSpectrum");
    
    ::SWGSDRangel::setValue(&dc_offset_correction, pJson["dcOffsetCorrection"], "qint32", "");
    
    ::SWGSDRangel::setValue(&iq_imbalance_correction, pJson["iqImbalanceCorrection"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&channel_configs, pJson["channelConfigs"], "QList", "SWGChannelConfig");
    
    ::SWGSDRangel::setValue(&device_configs, pJson["deviceConfigs"], "QList", "SWGDeviceConfig");
    ::SWGSDRangel::setValue(&layout, pJson["layout"], "QString", "QString");
    
}

QString
SWGPreset::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGPreset::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_preset_type_isSet){
        obj->insert("presetType", QJsonValue(preset_type));
    }
    if(group != nullptr && *group != QString("")){
        toJsonValue(QString("group"), group, obj, QString("QString"));
    }
    if(description != nullptr && *description != QString("")){
        toJsonValue(QString("description"), description, obj, QString("QString"));
    }
    if(m_center_frequency_isSet){
        obj->insert("centerFrequency", QJsonValue(center_frequency));
    }
    if((spectrum_config != nullptr) && (spectrum_config->isSet())){
        toJsonValue(QString("spectrumConfig"), spectrum_config, obj, QString("SWGGLSpectrum"));
    }
    if(m_dc_offset_correction_isSet){
        obj->insert("dcOffsetCorrection", QJsonValue(dc_offset_correction));
    }
    if(m_iq_imbalance_correction_isSet){
        obj->insert("iqImbalanceCorrection", QJsonValue(iq_imbalance_correction));
    }
    if(channel_configs && channel_configs->size() > 0){
        toJsonArray((QList<void*>*)channel_configs, obj, "channelConfigs", "SWGChannelConfig");
    }
    if(device_configs && device_configs->size() > 0){
        toJsonArray((QList<void*>*)device_configs, obj, "deviceConfigs", "SWGDeviceConfig");
    }
    if(layout != nullptr && *layout != QString("")){
        toJsonValue(QString("layout"), layout, obj, QString("QString"));
    }

    return obj;
}

qint32
SWGPreset::getPresetType() {
    return preset_type;
}
void
SWGPreset::setPresetType(qint32 preset_type) {
    this->preset_type = preset_type;
    this->m_preset_type_isSet = true;
}

QString*
SWGPreset::getGroup() {
    return group;
}
void
SWGPreset::setGroup(QString* group) {
    this->group = group;
    this->m_group_isSet = true;
}

QString*
SWGPreset::getDescription() {
    return description;
}
void
SWGPreset::setDescription(QString* description) {
    this->description = description;
    this->m_description_isSet = true;
}

qint64
SWGPreset::getCenterFrequency() {
    return center_frequency;
}
void
SWGPreset::setCenterFrequency(qint64 center_frequency) {
    this->center_frequency = center_frequency;
    this->m_center_frequency_isSet = true;
}

SWGGLSpectrum*
SWGPreset::getSpectrumConfig() {
    return spectrum_config;
}
void
SWGPreset::setSpectrumConfig(SWGGLSpectrum* spectrum_config) {
    this->spectrum_config = spectrum_config;
    this->m_spectrum_config_isSet = true;
}

qint32
SWGPreset::getDcOffsetCorrection() {
    return dc_offset_correction;
}
void
SWGPreset::setDcOffsetCorrection(qint32 dc_offset_correction) {
    this->dc_offset_correction = dc_offset_correction;
    this->m_dc_offset_correction_isSet = true;
}

qint32
SWGPreset::getIqImbalanceCorrection() {
    return iq_imbalance_correction;
}
void
SWGPreset::setIqImbalanceCorrection(qint32 iq_imbalance_correction) {
    this->iq_imbalance_correction = iq_imbalance_correction;
    this->m_iq_imbalance_correction_isSet = true;
}

QList<SWGChannelConfig*>*
SWGPreset::getChannelConfigs() {
    return channel_configs;
}
void
SWGPreset::setChannelConfigs(QList<SWGChannelConfig*>* channel_configs) {
    this->channel_configs = channel_configs;
    this->m_channel_configs_isSet = true;
}

QList<SWGDeviceConfig*>*
SWGPreset::getDeviceConfigs() {
    return device_configs;
}
void
SWGPreset::setDeviceConfigs(QList<SWGDeviceConfig*>* device_configs) {
    this->device_configs = device_configs;
    this->m_device_configs_isSet = true;
}

QString*
SWGPreset::getLayout() {
    return layout;
}
void
SWGPreset::setLayout(QString* layout) {
    this->layout = layout;
    this->m_layout_isSet = true;
}


bool
SWGPreset::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_preset_type_isSet){
            isObjectUpdated = true; break;
        }
        if(group && *group != QString("")){
            isObjectUpdated = true; break;
        }
        if(description && *description != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(spectrum_config && spectrum_config->isSet()){
            isObjectUpdated = true; break;
        }
        if(m_dc_offset_correction_isSet){
            isObjectUpdated = true; break;
        }
        if(m_iq_imbalance_correction_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_configs && (channel_configs->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(device_configs && (device_configs->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(layout && *layout != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

