% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guiTestReport.R
\name{guiTestReport}
\alias{guiTestReport}
\alias{guiSuiteList}
\alias{guiSuiteAutoList}
\alias{guiTestFeedback}
\title{Report or give feedback to the GUI client about running test units}
\usage{
guiTestReport(object, sep = "\\t", path = NULL, ...)

guiSuiteList(sep = "\\t", path = NULL, compare = TRUE)

guiSuiteAutoList(...)

guiTestFeedback(object, path = NULL, ...)
}
\arguments{
\item{object}{a 'svUnitData' object.}

\item{sep}{Field separator to use in the results.}

\item{path}{Path where to write a 'Suites.txt' file with the list of
currently available test suites (to be used by the GUI client). If \code{NULL},
no file is written (by default).}

\item{...}{Not used currently.}

\item{compare}{Do we compare the list of available test suite and return
something to the GUI client only if there are changes in the list? This is
used (when \code{TRUE}) to avoid unnecessary multiple processing of the same list
by the GUI client.}
}
\value{
\code{\link[=guiSuiteList]{guiSuiteList()}} returns the list of available test suites invisibly.
\code{\link[=guiSuiteAutoList]{guiSuiteAutoList()}} is used to establish a callback to automatically list
the available test suites in the GUI. It is not intended to be called
directly by the user. The other functions just return \code{TRUE} invisibly.They
are used for their side effect of sending data to compatible GUI clients.
}
\description{
These functions are usually not called from the command line. They return
data to compatible GUI clients, like Komodo Edit with the SciViews-K
extension.
}
\seealso{
\code{\link[=svTest]{svTest()}}, \code{\link[=svSuite]{svSuite()}}, \code{\link[=koUnit_version]{koUnit_version()}}
}
\author{
Philippe Grosjean
}
\concept{unit testing}
\keyword{utilities}
