% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{sv_email}
\alias{sv_email}
\title{Validate that a field contains an email address}
\usage{
sv_email(
  message = "Not a valid email address",
  allow_multiple = FALSE,
  allow_na = FALSE
)
}
\arguments{
\item{message}{The validation error message to use if a value doesn't match a
regex pattern for email address detection.}

\item{allow_multiple}{If \code{FALSE} (the default), then the length of the input
vector must be exactly one; if \code{TRUE}, then any length is allowed
(including a length of zero; use \code{\link[=sv_required]{sv_required()}} if one or more values
should be required).}

\item{allow_na}{If \code{FALSE}, then any \code{NA} element will cause validation to
fail.}
}
\value{
A function suitable for use as an
\code{\link[=InputValidator]{InputValidator$add_rule()}} rule.
}
\description{
A validation function, suitable for use with \code{InputValidator$add_rule()},
that checks whether an input value looks like a valid email address.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinyvalidate)

ui <- fluidPage(
  textInput("email", "Email")
)

server <- function(input, output, session) {
  
  # Validation rules are set in the server, start by
  # making a new instance of an `InputValidator()`
  iv <- InputValidator$new()

  # Basic usage: `sv_email()` works well with its
  # defaults; a message will be displayed if the
  # validation of `input$email` fails
  iv$add_rule("email", sv_email())

  # Finally, `enable()` the validation rules
  iv$enable()
}

shinyApp(ui, server)

}

}
\seealso{
The \code{\link[=sv_url]{sv_url()}} function, another specialized regex-based function
for validating URLs. For general regex-based validation the \code{\link[=sv_regex]{sv_regex()}}
function is useful.

Other rule functions: 
\code{\link{compose_rules}()},
\code{\link{sv_between}()},
\code{\link{sv_equal}()},
\code{\link{sv_gte}()},
\code{\link{sv_gt}()},
\code{\link{sv_in_set}()},
\code{\link{sv_integer}()},
\code{\link{sv_lte}()},
\code{\link{sv_lt}()},
\code{\link{sv_not_equal}()},
\code{\link{sv_numeric}()},
\code{\link{sv_optional}()},
\code{\link{sv_regex}()},
\code{\link{sv_required}()},
\code{\link{sv_url}()}
}
\concept{rule functions}
