% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr.R
\name{tbl.Pool}
\alias{tbl.Pool}
\alias{copy_to.Pool}
\title{Use pool with dbplyr}
\usage{
tbl.Pool(src, from, ..., vars = NULL)

copy_to.Pool(dest, df, name = NULL, overwrite = FALSE, temporary = TRUE, ...)
}
\arguments{
\item{src, dest}{A \link{dbPool}.}

\item{from}{Name table or \code{\link[dbplyr:sql]{dbplyr::sql()}} string.}

\item{...}{Other arguments passed on to the individual methods}

\item{vars}{A character vector of variable names in \code{src}.
For expert use only.}

\item{df}{A local data frame, a \code{tbl_sql} from same source, or a \code{tbl_sql}
from another source. If from another source, all data must transition
through R in one pass, so it is only suitable for transferring small
amounts of data.}

\item{name}{Name for remote table. Defaults to the name of \code{df}, if it's
an identifier, otherwise uses a random name.}

\item{overwrite}{If \code{TRUE}, will overwrite an existing table with
name \code{name}. If \code{FALSE}, will throw an error if \code{name} already
exists.}

\item{temporary}{if \code{TRUE}, will create a temporary table that is
local to this connection and will be automatically deleted when the
connection expires}
}
\description{
Wrappers for key dplyr (and dbplyr) methods so that pool works seemlessly
with \href{https://dbplyr.tidyverse.org/}{dbplyr}.
}
\examples{
library(dplyr)

pool <- dbPool(RSQLite::SQLite())
# copy a table into the database
copy_to(pool, mtcars, "mtcars", temporary = FALSE)

# retrieve a table
mtcars_db <- tbl(pool, "mtcars")
mtcars_db
mtcars_db \%>\% select(mpg, cyl, disp)
mtcars_db \%>\% filter(cyl == 6) \%>\% collect()

poolClose(pool)
}
