% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-residual-qqplot.R
\name{ols_plot_resid_qq}
\alias{ols_plot_resid_qq}
\title{Residual QQ plot}
\usage{
ols_plot_resid_qq(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
Graph for detecting violation of normality assumption.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_qq(model)

}
\seealso{
Other residual diagnostics: 
\code{\link{ols_plot_resid_box}()},
\code{\link{ols_plot_resid_fit}()},
\code{\link{ols_plot_resid_hist}()},
\code{\link{ols_test_correlation}()},
\code{\link{ols_test_normality}()}
}
\concept{residual diagnostics}
