% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-residual-plus-component-plot.R
\name{ols_plot_comp_plus_resid}
\alias{ols_plot_comp_plus_resid}
\title{Residual plus component plot}
\usage{
ols_plot_comp_plus_resid(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
The residual plus component plot indicates whether any non-linearity is
present in the relationship between response and predictor variables and can
suggest possible transformations for linearizing the data.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_plot_comp_plus_resid(model)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.

Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition).
Chicago, IL., McGraw Hill/Irwin.
}
\seealso{
\code{\link[=ols_plot_added_variable]{ols_plot_added_variable()}}, \code{\link[=ols_plot_resid_regressor]{ols_plot_resid_regressor()}}
}
