% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{gnm}
\alias{gnm}
\title{Generalized Nonlinear Models.}
\usage{
gnm(
  formula,
  family = gaussian(),
  offset = NULL,
  weights = NULL,
  data,
  subset = NULL,
  start = NULL,
  toler = 1e-05,
  maxit = 50,
  trace = FALSE,
  ...
)
}
\arguments{
\item{formula}{a \code{formula} expression which is a symbolic description of the "linear" predictor of the model to be fitted to the data.}

\item{family}{a description of the error distribution and link function to be used in the model. For \code{gnm} this can be a character string naming a family function,
a family function or the result of a call to a family function. As default, \code{family} is set to \code{gaussian(identity)}.}

\item{offset}{this can be used to specify an \emph{a priori} known component to be included in the linear predictor during fitting. This should be \code{NULL} or a numeric vector of length equal to the number of cases.}

\item{weights}{an (optional) vector of "prior weights" to be used in the fitting process. The length of \code{weights} should be the same as the number of observations.}

\item{data}{an (optional) data frame, list or environment (or object coercible by \link{as.data.frame} to a data frame) containing the variables in the model.
If not found in data, the variables are taken from \code{environment(formula)}, typically the environment from which \code{gnm} is called.}

\item{subset}{an (optional) vector specifying a subset of observations to be used in the fitting process.}

\item{start}{an (optional) vector of starting values for the parameters in the "linear" predictor.}

\item{toler}{an (optional) positive value which represents the \emph{convergence tolerance}. The convergence is reached when the maximum of the absolute relative
differences between the values of the parameters in the "linear" predictor in consecutive iterations of the fitting algorithm is lower than \code{toler}. As
default, \code{toler} is set to 0.00001.}

\item{maxit}{an (optional) integer value which represents the maximum number of iterations allowed for the fitting algorithm. As default, \code{maxit} is set to 50.}

\item{trace}{an (optional) logical variable. If \code{TRUE}, output is produced for each iteration of the estimating algorithm.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of class \emph{gnm} in which the main results of the model fitted to the data are stored, i.e., a
list with components including
\tabular{ll}{
\code{coefficients} \tab a vector containing the parameter estimates,\cr
\tab \cr
\code{fitted.values}\tab a vector containing the estimates of \eqn{\mu_1,\ldots,\mu_n},\cr
\tab \cr
\code{start}        \tab a vector containing the starting values used,\cr
\tab \cr
\code{prior.weights}\tab a vector containing the case weights used,\cr
\tab \cr
\code{offset}       \tab a vector containing the offset used, \cr
\tab \cr
\code{terms}        \tab an object containing the terms objects,\cr
\tab \cr
\code{loglik}       \tab the value of the log-likelihood function avaliated at the parameter estimates,\cr
\tab \cr
\code{estfun}       \tab a vector containing the estimating functions evaluated at the parameter estimates\cr
                    \tab and the observed data,\cr
\tab \cr
\code{formula}      \tab the formula,\cr
\tab \cr
\code{converged}    \tab a logical indicating successful convergence,\cr
\tab \cr
\code{model}        \tab the full model frame,\cr
\tab \cr
\code{y}            \tab the response vector,\cr
\tab \cr
\code{family}       \tab an object containing the \link{family} object used,\cr
\tab \cr
\code{linear.predictors} \tab a vector containing the estimates of \eqn{g(\mu_1),\ldots,g(\mu_n)},\cr
\tab \cr
\code{R}            \tab a matrix with unscaled estimate of the variance-covariance\cr
                    \tab matrix of model parameters,\cr
\tab \cr
\code{call}         \tab the original function call.\cr
}
}
\description{
\code{gnm} is used to fit generalized nonlinear models, specified by giving a symbolic description of the "linear" predictor
             and a description of the error distribution.
}
\details{
A set of standard extractor functions for fitted model objects is available for objects of class \emph{gnm},
including methods to the generic functions such as \code{summary}, \code{model.matrix}, \code{estequa},
\code{coef}, \code{vcov}, \code{logLik}, \code{fitted}, \code{confint}, \code{AIC}, \code{BIC} and \code{predict}.
In addition, the model fitted to the	data may be assessed using functions such as \code{adjR2.gnm}, \link{anova.gnm},
\link{residuals.gnm}, \link{dfbeta.gnm}, \link{cooks.distance.gnm}, \link{localInfluence.gnm} and \link{envelope.gnm}.
}
\examples{
###### Example 1: The effects of fertilizers on coastal Bermuda grass
data(Grass)
fit1 <- gnm(Yield ~ b0 + b1/(Nitrogen + a1) + b2/(Phosphorus + a2) + b3/(Potassium + a3),
            family=gaussian(inverse), start=c(b0=0.1,b1=13,b2=1,b3=1,a1=45,a2=15,a3=30), data=Grass)
summary(fit1)

###### Example 2: Assay of an Insecticide with a Synergist
data(Melanopus)
fit2 <- gnm(Killed/Exposed ~ b0 + b1*log(Insecticide-a1) + b2*Synergist/(a2 + Synergist),
            family=binomial(logit), weights=Exposed, start=c(b0=-3,b1=1.2,a1=1.7,b2=1.7,a2=2),
		   data=Melanopus)
summary(fit2)

###### Example 3: Developmental rate of Drosophila melanogaster
data(Drosophila)
fit3 <- gnm(Duration ~ b0 + b1*Temp + b2/(Temp-a), family=Gamma(log),
            start=c(b0=3,b1=-0.25,b2=-210,a=55), weights=Size, data=Drosophila)
summary(fit3)

###### Example 4: Radioimmunological Assay of Cortisol
data(Cortisol)
fit4 <- gnm(Y ~ b0 + (b1-b0)/(1 + exp(b2+ b3*lDose))^b4, family=Gamma(identity),
            start=c(b0=130,b1=2800,b2=3,b3=3,b4=0.5), data=Cortisol)
summary(fit4)

###### Example 5: Age and Eye Lens Weight of Rabbits in Australia
data(rabbits)
fit5 <- gnm(wlens ~ b1 - b2/(age + b3), family=Gamma(log),
            start=c(b1=5.5,b2=130,b3=35), data=rabbits)
summary(fit5)

###### Example 6: Calls to a technical support help line
data(calls)
fit6 <- gnm(calls ~ SSlogis(week, Asym, xmid, scal), family=poisson(identity), data=calls)
summary(fit6)

}
\seealso{
\link{glm}, \link{glmgee}, \link{gnmgee}
}
