% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart.R
\name{line_chart}
\alias{line_chart}
\title{Line Chart}
\usage{
line_chart(data, x, y, group, line_color = "auto", line_size = 1)
}
\arguments{
\item{data}{Dataset used for the line chart}

\item{x}{\code{numeric} column of \code{data}}

\item{y}{\code{numeric} column of \code{data} or a \code{tdiyselect} expression}

\item{group}{\code{character} or \code{factor} column of \code{data} defining individual lines}

\item{line_color}{\code{character}. Line color}

\item{line_size}{\code{character} Line width in mm}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a line chart
}
\details{
For plotting multiple lines \code{line_chart()} can handle data in long or wide format.
If the data is in long format pass the variable that identifies individual lines
to the \code{group} argument. If the data is in wide format pass a selection of variables
to the \code{y} argument.
}
\examples{
library(dplyr)
data("biomedicalrevenue")
data("revenue_wide")

line_chart(revenue_wide, year, Roche)

line_chart(revenue_wide, year, Roche, line_size = 1.5)

line_chart(revenue_wide, year, Roche, line_color = "darkorange")

## Plot multiple lines (data is in long format)
biomedicalrevenue \%>\%
  filter(company \%in\% c("Roche", "Novartis", "Bayer")) \%>\%
  line_chart(year, revenue, group = company)

## Plot multiple lines (data in wide format, i.e. one column per line)
## Select multiple columns with `c()`
line_chart(revenue_wide, year, c(Roche, Novartis, Bayer))

## Select all columns from Novartis to Sanofi suing `:`
line_chart(revenue_wide, year, Novartis:Sanofi)

## Select all columns starting with "B"
line_chart(revenue_wide, year, starts_with("B"))

}
\author{
Thomas Neitmann
}
