% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_operations.R
\name{spa_add_component}
\alias{spa_add_component}
\title{Add components to a \code{pgeometry} object}
\usage{
spa_add_component(pgo, components, is_valid = FALSE)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}

\item{components}{A \code{component} object or a list of \code{component} objects.}

\item{is_valid}{A Boolean value to check if the user wants to validate the updated spatial plateau object at the end. If \code{is_valid = TRUE}, it calls \code{validObject()} method.}
}
\value{
A \code{pgeometry} object containing the \code{component} objects.
}
\description{
\code{spa_add_component()} inserts components into a spatial plateau object (i.e., \code{pgeometry} object).
}
\details{
This function implements the \eqn{\odot}{odot} operator defined by Spatial Plateau Algebra.
The goal of this function is to insert a component or a list of components into a \code{pgeometry} object.
The crisp spatial object of the component must be compatible with the type of the plateau spatial object.
For instance, a \code{pregion} object accepts only components containing polygons (e.g., \code{POLYGON} or \code{MULTIPOLYGON}).
In the case of \code{pcomposition} object any type of component is compatible to be added.
For instance, a point component is added to the plateau point sub-object of the plateau composition object.
On the other hand, as a \code{pcollection} object can have multiple spatial objects of the same type, this function is not applicable to it.

The insertion is based on the membership degree of the component. Thus, it preserves the properties of a spatial plateau object.
However, \code{spa_add_component()} assumes that the geometric format of the component is valid (i.e., it does not overlap with existing components).
}
\examples{
comp1 <- create_component("MULTIPOINT(1 1, 2 2)", 0.2) 
comp2 <- create_component("POINT(1 5)", 0.8)  

# appending these components into an empty pgeometry object
pp <- create_empty_pgeometry("PLATEAUPOINT")
pp <- spa_add_component(pp, list(comp1, comp2))
pp

# inserting components with existing membership degrees are merged
comp3 <- create_component("MULTIPOINT(0 0, 4 4)", 0.2)
pp <- spa_add_component(pp, comp3)
pp

comp4 <- create_component("MULTIPOINT(0 1, 3 4)", 1)
pc <- create_pgeometry(list(comp4), "PLATEAUCOMPOSITION")
pc

# appending these components into pc
comp5 <- create_component("LINESTRING(-1 1, 2 2)", 0.9)
comp6 <- create_component("POLYGON((0 0, 1 4, 2 2, 0 0))", 0.4)
pc <- spa_add_component(pc, list(comp5, comp6))
pc
}
\references{
The formal definition of the \eqn{\odot}{odot} operator is described in:
\itemize{
\item \href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
}
