% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_functions.R
\name{remove.close.ellipse}
\alias{remove.close.ellipse}
\title{A Helper Function to Tell Which Points are Near the Boundary of the Ellipse}
\usage{
remove.close.ellipse(ps, x, y, a, b, alpha)
}
\arguments{
\item{ps}{an n x 2 matrix of potential points.}

\item{x}{the x coordinate of the center of the ellipse.}

\item{y}{the y coordinate of the center of the ellipse.}

\item{a}{the x-radius of the ellipse.}

\item{b}{the y-radius of the ellipse.}

\item{alpha}{the angle of rotation of the ellipse.}
}
\value{
\item{inds}{a vector of length nrow(ps) that tells whether each row
of ps is near the border of the ellipse defined by x,y,a,b, and alpha. }
}
\description{
A helper function.
}
\examples{


## The function is currently defined as
ps <- cbind(runif(100), runif(100))
inds <- dga:::remove.close.ellipse(ps, .5, .5, .1, .3, 1)
}
\author{
Kristian Lum \email{kl@hrdag.org}
}
\keyword{ellipse}
