% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conogive.R
\name{predict.conogive}
\alias{predict.conogive}
\title{Predict Method for Conogive Objects}
\usage{
\method{predict}{conogive}(object, newdata, weights = c("optimal", "equal"), ...)
}
\arguments{
\item{object}{An object of class "\code{conogive}".}

\item{newdata}{An optional data frame with variables to predict with.
The fitted values are used if omitted.}

\item{weights}{Weights to use; choose between optimal weights and equal
weights.}

\item{...}{Ignored.}
}
\description{
Predict the latent variable in a congeneric normal-ogive model using the
formula of ((arxiv ref.))
}
\examples{
 if(require("psychTools")) {
   extraversion = psychTools::bfi[c("E1", "E2", "E3", "E4", "E5")]
   extraversion[, "E1"] = 7 - extraversion[, "E1"] # Reverse-coded item.
   extraversion[, "E2"] = 7 - extraversion[, "E2"] # Reverse-coded item.
   object = conogive(extraversion)
   hist(predict(object, extraversion)) # Plot distribution of predictions.
 }
}
