% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{samplesPlot}
\alias{samplesPlot}
\title{Plot MCMC traceplots and density plots}
\usage{
samplesPlot(
  samples,
  var = colnames(samples),
  ind = NULL,
  burnin = NULL,
  scale = FALSE,
  line = NULL,
  width = 7,
  height = 4,
  legend = TRUE,
  legend.location = "topright",
  traceplot = TRUE,
  densityplot = TRUE,
  file = NULL
)
}
\arguments{
\item{samples}{Array of MCMC samples, or a list of samples from multiple chains in which case the first chain is used}

\item{var}{Parameter names to plot}

\item{ind}{Indices of MCMC samples to plot}

\item{burnin}{Number of initial MCMC samples to discard (default: 0)}

\item{scale}{Logical, whether to normalize each posterior chain}

\item{line}{Numeric vector of true parameter values for adding lines to plots}

\item{width}{Width of the plot}

\item{height}{Height of the plot}

\item{legend}{Logical, whether to include a legend of parameter names}

\item{legend.location}{Location of legend}

\item{traceplot}{Logical, whether to include traceplots (default: TRUE)}

\item{densityplot}{Logaical, whether to include density plots (default: TRUE)}

\item{file}{Optional filename to save figure as a file}
}
\description{
Plot MCMC traceplots and density plots
}
\examples{
samples <- cbind(rnorm(1000), rgamma(1000, 1))
colnames(samples) <- c('alpha', 'beta')
samplesPlot(samples)

}
