% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{res}
\alias{res}
\title{The restricted estimator}
\usage{
res(X, y, H, h)
}
\arguments{
\item{X}{Matrix with input observations, of dimension \code{n} x \code{p};
each row is an observation vector.}

\item{y}{Vector with response observations of size \code{n}.}

\item{H}{A given \code{q} x \code{p} matrix.}

\item{h}{A given \code{q} x \code{1} vector.}
}
\value{
An object of class \code{restricted} is a list containing at least the following components:
  \describe{
    \item{\code{coef}}{A named vector of coefficients.}
    \item{\code{residuals}}{The residuals, that is, the response values minus fitted values.}
    \item{\code{s2}}{The estimated variance.}
    \item{\code{fitted.values}}{The fitted values.}
  }
}
\description{
This function calculates the restricted estimator using
\deqn{\hat{\beta}^{R} = \hat{\beta}^{U} - (X^{\top}X)^{-1}H^{\top}
(H(X^{\top}X)^{-1}H^{\top})^{-1}(H\hat{\beta}^{U}-h)}
where \eqn{H\beta = h} represents a subspace of the parameter space induced
by the non-sample information. Here, \eqn{H} is a known \eqn{q \times p}
matrix, and \eqn{h} is a known \eqn{q}-vector.
}
\details{
#' The corresponding estimator of \eqn{\sigma^2} is
\deqn{s^2 = \frac{1}{n-p}(y-X\hat{\beta}^{R})^{\top}(y - X\hat{\beta}^{R}).}
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
res(X, y, H, h)

# H beta != h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(1, nrow(H))
res(X, y, H, h)


data(cement)
X <- as.matrix(cbind(1, cement[, 1:4]))
y <- cement$y
# Based on Kaciranlar et al. (1999)
H <- matrix(c(0, 1, -1, 1, 0), nrow = 1, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
res(X, y, H, h)
# Based on Kibria (2005)
H <- matrix(c(0, 1, -1, 1, 0, 0, 0, 1, -1, -1, 0, 1, -1, 0, -1), nrow = 3, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
res(X, y, H, h)
}
\references{
Saleh, A. K. Md. Ehsanes. (2006). \emph{Theory of Preliminary Test and
 Stein‐Type Estimation With Applications}, Wiley.

Kaciranlar, S., Akdeniz, S. S. F., Styan, G. P. & Werner, H. J. (1999). A new biased
estimators in linear regression and detailed
analysis of the widely-analysed dataset on
portland cement. \emph{Sankhya, Series B}, 61(3), 443-459.

Kibria, B. M. Golam (2005). Applications of Some Improved Estimators in Linear Regression,
\emph{Journal of Modern Applied Statistical Methods}, 5(2), 367- 380.
}
